-------------------------------------------------------------------------------
-- Copyright (c) 1995/2004 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                  18X18 Signed Multiplier Followed by Three-Input Adder with Pipeline Registers
-- /___/   /\     Filename : X_DSP48.vhd
-- \   \  /  \    Timestamp : Fri Mar 26 08:18:19 PST 2004
--  \___\/\___\
--
-- Revision:
--    03/23/04 - Initial version.
--    05/25/05 - CR 204870 changed all bit_vector message calls to strings.
--    06/30/05 - CR 210790 fixed CheckEnabled in Vital so that timing.
--               violation are not reported when global GSR_dly = 1.
--    01/17/06 - CR 224235 CECARRYIN, CECINSUB fasle hold violation fix.
--    02/28/06 - CR 225886 -- LEGACY_MODE check updates.
--    06/30/06 - CR 234078 -- Fixed False Timing error on RSTCARRYIN
--    08/21/06 - CR 232521 -- fixed DRC check to allow "0010101_11"
--    02/06/08 - CR 455601 -- DRC relax for OPMODEREG/CARRYINSELREG
--    04/07/08 - CR 469973 -- Header Description fix
--    27/05/08 - CR 472154 Removed Vital GSR constructs
--    08/20/08 - CR 479833 -- DRC relax for OPMODEREG/CARRYINSELREG
-- End Revision
----- CELL X_DSP48 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_SIGNED.all;
use IEEE.STD_LOGIC_ARITH.all;

library STD;
use STD.TEXTIO.all;


library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.Vcomponents.all;
use simprim.VPACKAGE.all;

entity X_DSP48 is

  generic(

        TimingChecksOn  : boolean       := true;
        InstancePath    : string        := "*";
        Xon             : boolean       := true;
        MsgOn           : boolean       := true;

----- VITAL input wire delays
        tipd_A          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_B          : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_BCIN       : VitalDelayArrayType01 (17 downto 0) := (others => (0 ps, 0 ps));
        tipd_C          : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_CARRYIN    : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CARRYINSEL : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
        tipd_CEA        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEB        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEC        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECARRYIN  : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECINSUB   : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CECTRL     : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEM        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CEP        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_CLK        : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_OPMODE     : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
        tipd_PCIN       : VitalDelayArrayType01 (47 downto 0) := (others => (0 ps, 0 ps));
        tipd_RSTA       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTB       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTC       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTCARRYIN : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTCTRL    : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTP       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_RSTM       : VitalDelayType01 := ( 0 ps,  0 ps);
        tipd_SUBTRACT   : VitalDelayType01 := ( 0 ps,  0 ps);

----- VITAL pin-to-pin propagation delays

        tpd_A_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_A_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_B_BCOUT     : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_P         : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_B_PCOUT     : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_BCIN_BCOUT  : VitalDelayArrayType01 (323 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_P      : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));
        tpd_BCIN_PCOUT  : VitalDelayArrayType01 (863 downto 0)  := (others => (0 ps, 0 ps));

        tpd_C_P         : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_C_PCOUT     : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));

        tpd_CARRYIN_P     : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYIN_PCOUT : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

        tpd_CARRYINSEL_P     : VitalDelayArrayType01 (95 downto 0)  := (others => (0 ps, 0 ps));
        tpd_CARRYINSEL_PCOUT : VitalDelayArrayType01 (95 downto 0)  := (others => (0 ps, 0 ps));

        tpd_CLK_P       : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_PCOUT   : VitalDelayArrayType01 (47 downto 0)  := (others => (100 ps, 100 ps));
        tpd_CLK_BCOUT   : VitalDelayArrayType01 (17 downto 0)  := (others => (100 ps, 100 ps));

        tpd_OPMODE_P     : VitalDelayArrayType01 (335 downto 0)  := (others => (0 ps, 0 ps));
        tpd_OPMODE_PCOUT : VitalDelayArrayType01 (335 downto 0)  := (others => (0 ps, 0 ps));

        tpd_PCIN_P      : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));
        tpd_PCIN_PCOUT  : VitalDelayArrayType01 (2303 downto 0)  := (others => (0 ps, 0 ps));

        tpd_SUBTRACT_P     : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));
        tpd_SUBTRACT_PCOUT : VitalDelayArrayType01 (47 downto 0)  := (others => (0 ps, 0 ps));

----- VITAL setup and hold times
       
        tsetup_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tsetup_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tsetup_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tsetup_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECINSUB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECINSUB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tsetup_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tsetup_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tsetup_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        tsetup_SUBTRACT_CLK_posedge_posedge : VitalDelayType := 0 ps;
        tsetup_SUBTRACT_CLK_negedge_posedge : VitalDelayType := 0 ps;

        thold_A_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_A_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_B_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_B_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_posedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_BCIN_CLK_negedge_posedge : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        thold_C_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_C_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_CARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CARRYINSEL_CLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        thold_CARRYINSEL_CLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        thold_CEA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECINSUB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECINSUB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CECTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CECTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_CEM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_OPMODE_CLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        thold_OPMODE_CLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_posedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_PCIN_CLK_negedge_posedge : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        thold_RSTA_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTA_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTB_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTC_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCARRYIN_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCARRYIN_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCTRL_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTCTRL_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTP_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_RSTM_CLK_negedge_posedge : VitalDelayType := 0 ps;
        thold_SUBTRACT_CLK_posedge_posedge : VitalDelayType := 0 ps;
        thold_SUBTRACT_CLK_negedge_posedge : VitalDelayType := 0 ps;

----- VITAL clock ticd delays
        ticd_CLK        : VitalDelayType  := 0 ps;
     
----- VITAL clock-to-pin tisd delays
        tisd_A_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_B_CLK              : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_BCIN_CLK           : VitalDelayArrayType(17 downto 0) := (others => 0 ps);
        tisd_C_CLK              : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_CARRYIN_CLK        : VitalDelayType  := 0 ps;
        tisd_CARRYINSEL_CLK     : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_CEA_CLK            : VitalDelayType  := 0 ps;
        tisd_CEB_CLK            : VitalDelayType  := 0 ps;
        tisd_CEC_CLK            : VitalDelayType  := 0 ps;
        tisd_CECARRYIN_CLK      : VitalDelayType  := 0 ps;
        tisd_CECINSUB_CLK       : VitalDelayType  := 0 ps;
        tisd_CECTRL_CLK         : VitalDelayType  := 0 ps;
        tisd_CEM_CLK            : VitalDelayType  := 0 ps;
        tisd_CEP_CLK            : VitalDelayType  := 0 ps;
        tisd_OPMODE_CLK         : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tisd_PCIN_CLK           : VitalDelayArrayType(47 downto 0) := (others => 0 ps);
        tisd_RSTA_CLK           : VitalDelayType := 0 ps;
        tisd_RSTB_CLK           : VitalDelayType := 0 ps;
        tisd_RSTC_CLK           : VitalDelayType := 0 ps;
        tisd_RSTCARRYIN_CLK     : VitalDelayType := 0 ps;
        tisd_RSTCTRL_CLK        : VitalDelayType := 0 ps;
        tisd_RSTM_CLK           : VitalDelayType := 0 ps;
        tisd_RSTP_CLK           : VitalDelayType := 0 ps;
        tisd_SUBTRACT_CLK       : VitalDelayType := 0 ps;

----- VITAL period check 
        tperiod_CLK_posedge     : VitalDelayType := 0 ps;

----- VITAL pulse width
        tpw_CLK_negedge         : VitalDelayType := 0 ps;
        tpw_CLK_posedge         : VitalDelayType := 0 ps;

----- VITAL Recovery

        AREG            : integer       := 1;
        B_INPUT         : string        := "DIRECT";
        BREG            : integer       := 1;
        CARRYINREG      : integer       := 1;
        CARRYINSELREG   : integer       := 1;
        CREG            : integer       := 1;
        LEGACY_MODE     : string        := "MULT18X18S";
        LOC     	: string        := "UNPLACED";
        MREG            : integer       := 1;
        OPMODEREG       : integer       := 1;
        PREG            : integer       := 1;
        SUBTRACTREG     : integer       := 1
        );

  port(
        BCOUT                   : out std_logic_vector(17 downto 0);
        P                       : out std_logic_vector(47 downto 0);
        PCOUT                   : out std_logic_vector(47 downto 0);

        A                       : in  std_logic_vector(17 downto 0);
        B                       : in  std_logic_vector(17 downto 0);
        BCIN                    : in  std_logic_vector(17 downto 0);
        C                       : in  std_logic_vector(47 downto 0);
        CARRYIN                 : in  std_ulogic;
        CARRYINSEL              : in  std_logic_vector(1 downto 0);
        CEA                     : in  std_ulogic;
        CEB                     : in  std_ulogic;
        CEC                     : in  std_ulogic;
        CECARRYIN               : in  std_ulogic;
        CECINSUB                : in  std_ulogic;
        CECTRL                  : in  std_ulogic;
        CEM                     : in  std_ulogic;
        CEP                     : in  std_ulogic;
        CLK                     : in  std_ulogic;
        OPMODE                  : in  std_logic_vector(6 downto 0);
        PCIN                    : in  std_logic_vector(47 downto 0);
        RSTA                    : in  std_ulogic;
        RSTB                    : in  std_ulogic;
        RSTC                    : in  std_ulogic;
        RSTCARRYIN              : in  std_ulogic;
        RSTCTRL                 : in  std_ulogic;
        RSTM                    : in  std_ulogic;
        RSTP                    : in  std_ulogic;
        SUBTRACT                : in  std_ulogic
      );

  attribute VITAL_LEVEL0 of X_DSP48 :     entity is true;

end X_DSP48;

-- architecture body                    --

architecture X_DSP48_V of X_DSP48 is

    procedure invalid_opmode_preg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48 instance "));
       Write ( Message, string'("requires attribute PREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_preg_msg;

    procedure invalid_opmode_mreg_msg( OPMODE : IN string ; 
                                   CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48 instance "));
       Write ( Message, string'("requires attribute MREG set to 1."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_mreg_msg;

    procedure invalid_opmode_no_mreg_msg( OPMODE : IN string ; 
                                      CARRYINSEL : IN string ) is
    variable Message : line;
    begin
       Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
       Write ( Message,  OPMODE);
       Write ( Message, string'(" with CARRYINSEL "));
       Write ( Message,  CARRYINSEL);
       Write ( Message, string'(" to X_DSP48 instance "));
       Write ( Message, string'("requires attribute MREG set to 0."));
       assert false report Message.all severity Warning;
       DEALLOCATE (Message);
    end invalid_opmode_no_mreg_msg;


  attribute VITAL_LEVEL0 of X_DSP48_V : architecture is true;

  TYPE VitalTimingDataArrayType IS ARRAY (NATURAL RANGE <>)
         OF VitalTimingDataType;



  constant SYNC_PATH_DELAY : time := 100 ps;

  constant MAX_P          : integer    := 48;
  constant MAX_PCIN       : integer    := 48;
  constant MAX_OPMODE     : integer    := 7;
  constant MAX_BCIN       : integer    := 18;
  constant MAX_B          : integer    := 18;
  constant MAX_A          : integer    := 18;
  constant MAX_C          : integer    := 48;

  constant MSB_PCIN       : integer    := 47;
  constant MSB_OPMODE     : integer    := 6;
  constant MSB_BCIN       : integer    := 17;
  constant MSB_B          : integer    := 17;
  constant MSB_A          : integer    := 17;
  constant MSB_C          : integer    := 47;
  constant MSB_CARRYINSEL : integer    := 1;

  constant MSB_P          : integer    := 47;
  constant MSB_PCOUT      : integer    := 47;
  constant MSB_BCOUT      : integer    := 17;

  constant SHIFT_MUXZ     : integer    := 17;

  signal 	A_ipd		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	B_ipd		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_ipd	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_ipd		: std_logic_vector(MSB_C downto 0)    := (others => '0');
  signal 	CARRYIN_ipd	: std_ulogic := '0';
  signal 	CARRYINSEL_ipd	: std_logic_vector(MSB_CARRYINSEL downto 0)  := (others => '0');
  signal 	CEA_ipd		: std_ulogic := '0';
  signal 	CEB_ipd		: std_ulogic := '0';
  signal 	CEC_ipd		: std_ulogic := '0';
  signal 	CECARRYIN_ipd	: std_ulogic := '0';
  signal 	CECINSUB_ipd	: std_ulogic := '0';
  signal 	CECTRL_ipd	: std_ulogic := '0';
  signal 	CEM_ipd		: std_ulogic := '0';
  signal 	CEP_ipd		: std_ulogic := '0';
  signal 	CLK_ipd		: std_ulogic := '0';
  signal 	GSR_ipd		: std_ulogic := '0';
  signal 	OPMODE_ipd	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_ipd	: std_logic_vector(MSB_PCIN downto 0) := (others => '0');
  signal 	RSTA_ipd	: std_ulogic := '0';
  signal 	RSTB_ipd	: std_ulogic := '0';
  signal 	RSTC_ipd	: std_ulogic := '0';
  signal 	RSTCARRYIN_ipd	: std_ulogic := '0';
  signal 	RSTCTRL_ipd	: std_ulogic := '0';
  signal 	RSTM_ipd	: std_ulogic := '0';
  signal 	RSTP_ipd	: std_ulogic := '0';
  signal 	SUBTRACT_ipd	: std_ulogic := '0';

  signal 	A_dly		: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal 	B_dly		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal 	BCIN_dly	: std_logic_vector(MSB_BCIN downto 0) := (others => '0');
  signal 	C_dly		: std_logic_vector(MSB_C downto 0) := (others => '0');
  signal 	CARRYIN_dly	: std_ulogic := '0';
  signal 	CARRYINSEL_dly	: std_logic_vector(MSB_CARRYINSEL downto 0)  := (others => '0');
  signal 	CEA_dly		: std_ulogic := '0';
  signal 	CEB_dly		: std_ulogic := '0';
  signal 	CEC_dly		: std_ulogic := '0';
  signal 	CECARRYIN_dly	: std_ulogic := '0';
  signal 	CECINSUB_dly	: std_ulogic := '0';
  signal 	CECTRL_dly	: std_ulogic := '0';
  signal 	CEM_dly		: std_ulogic := '0';
  signal 	CEP_dly		: std_ulogic := '0';
  signal 	CLK_dly		: std_ulogic := '0';
  signal 	GSR_dly		: std_ulogic := '0';
  signal 	OPMODE_dly	: std_logic_vector(MSB_OPMODE downto 0)  := (others => '0');
  signal 	PCIN_dly	: std_logic_vector(MSB_PCIN downto 0)     := (others => '0');
  signal 	RSTA_dly	: std_ulogic := '0';
  signal 	RSTB_dly	: std_ulogic := '0';
  signal 	RSTC_dly	: std_ulogic := '0';
  signal 	RSTCARRYIN_dly	: std_ulogic := '0';
  signal 	RSTCTRL_dly	: std_ulogic := '0';
  signal 	RSTM_dly	: std_ulogic := '0';
  signal 	RSTP_dly	: std_ulogic := '0';
  signal 	SUBTRACT_dly	: std_ulogic := '0';

  signal	BCOUT_zd	: std_logic_vector(MSB_BCOUT downto 0) := (others => '0');
  signal	P_zd		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	PCOUT_zd		: std_logic_vector(MSB_PCOUT downto 0) := (others => '0');
  
  --- Internal Signal Declarations
  signal	qa_o_reg1	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_reg2	: std_logic_vector(MSB_A downto 0) := (others => '0');
  signal	qa_o_mux	: std_logic_vector(MSB_A downto 0) := (others => '0');

  signal	b_o_mux		: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg1	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_reg2	: std_logic_vector(MSB_B downto 0) := (others => '0');
  signal	qb_o_mux	: std_logic_vector(MSB_B downto 0) := (others => '0');

  signal	qc_o_reg        : std_logic_vector(MSB_C downto 0) := (others => '0');
  signal	qc_o_mux	: std_logic_vector(MSB_C downto 0) := (others => '0');

  signal	mult_o_int	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');
  signal	mult_o_reg	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');
  signal	mult_o_mux	: std_logic_vector((MSB_A + MSB_B + 1) downto 0) := (others => '0');

  signal	opmode_o_reg	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');
  signal	opmode_o_mux	: std_logic_vector(MSB_OPMODE downto 0) := (others => '0');

  signal	muxx_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxy_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	muxz_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	subtract_o_reg	: std_ulogic := '0';
  signal	subtract_o_mux	: std_ulogic := '0';

  signal	carryinsel_o_reg	: std_logic_vector(MSB_CARRYINSEL downto 0) := (others => '0');
  signal	carryinsel_o_mux	: std_logic_vector(MSB_CARRYINSEL downto 0) := (others => '0');

  signal	qcarryin_o_reg1	: std_ulogic := '0';
  signal	carryin0_o_mux	: std_ulogic := '0';
  signal	carryin1_o_mux	: std_ulogic := '0';
  signal	carryin2_o_mux	: std_ulogic := '0';

  signal	qcarryin_o_reg2	: std_ulogic := '0';

  signal	carryin_o_mux	: std_ulogic := '0';

  signal	accum_o		: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	qp_o_reg	: std_logic_vector(MSB_P downto 0) := (others => '0');
  signal	qp_o_mux	: std_logic_vector(MSB_P downto 0) := (others => '0');

  signal	add_i_int      : std_logic_vector(47 downto 0) := (others => '0');
  signal	add_o_int      : std_logic_vector(47 downto 0) := (others => '0');

  signal	reg_p_int         : std_logic_vector(47 downto 0) := (others => '0');
  signal	p_o_int         : std_logic_vector(47 downto 0) := (others => '0');

  signal	subtract1_o_int : std_ulogic := '0';
  signal	carryinsel1_o_int : std_logic_vector(1 downto 0) := (others => '0');
  signal	carry1_o_int     : std_ulogic := '0';
  signal	carry2_o_int     : std_ulogic := '0';


  signal	output_x_sig	: std_ulogic := '0';

  signal   RST_META          : std_ulogic := '0';

  signal   DefDelay          : time := 10 ps;

begin

  GSR_dly <= GSR;

  ---------------------
  --  INPUT PATH DELAYs
  ---------------------

  WireDelay     : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalWireDelay (A_ipd(i),    A(i),        tipd_A(i));
    end generate A_Delay;    

    B_Delay : for i in MSB_B downto 0 generate
        VitalWireDelay (B_ipd(i),    B(i),        tipd_B(i));
    end generate B_Delay;    

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalWireDelay (BCIN_ipd(i),  BCIN(i),      tipd_BCIN(i));
    end generate BCIN_Delay;    

    C_Delay : for i in MSB_C downto 0 generate
        VitalWireDelay (C_ipd(i),    C(i),        tipd_C(i));
    end generate C_Delay;    

    VitalWireDelay (CARRYIN_ipd,    CARRYIN,    tipd_CARRYIN);

    CARRYINSEL_delay : for i in MSB_CARRYINSEL downto 0 generate
        VitalWireDelay (CARRYINSEL_ipd(i), CARRYINSEL(i),    tipd_CARRYINSEL(i));    
    end generate CARRYINSEL_delay;

    VitalWireDelay (CEA_ipd,        CEA,        tipd_CEA);
    VitalWireDelay (CEB_ipd,        CEB,        tipd_CEB);
    VitalWireDelay (CEC_ipd,        CEC,        tipd_CEC);
    VitalWireDelay (CECARRYIN_ipd,  CECARRYIN,  tipd_CECARRYIN);
    VitalWireDelay (CECINSUB_ipd,   CECINSUB,   tipd_CECINSUB);
    VitalWireDelay (CECTRL_ipd,     CECTRL,     tipd_CECTRL);
    VitalWireDelay (CEM_ipd,        CEM,        tipd_CEM);
    VitalWireDelay (CEP_ipd,        CEP,        tipd_CEP);

    VitalWireDelay (CLK_ipd,        CLK,        tipd_CLK);

    OPMODE_delay : for i in MSB_OPMODE downto 0 generate
        VitalWireDelay (OPMODE_ipd(i),     OPMODE(i),    tipd_OPMODE(i));    
    end generate OPMODE_delay;

    Pin_Delay : for i in MSB_PCIN downto 0 generate
        VitalWireDelay (PCIN_ipd(i),     PCIN(i),    tipd_PCIN(i));
    end generate Pin_Delay;    

    VitalWireDelay (RSTA_ipd,        RSTA,        tipd_RSTA);
    VitalWireDelay (RSTB_ipd,        RSTB,        tipd_RSTB);
    VitalWireDelay (RSTC_ipd,        RSTC,        tipd_RSTC);
    VitalWireDelay (RSTCARRYIN_ipd,    RSTCARRYIN,    tipd_RSTCARRYIN);
    VitalWireDelay (RSTCTRL_ipd,     RSTCTRL,     tipd_RSTCTRL);
    VitalWireDelay (RSTM_ipd,        RSTM,        tipd_RSTM);
    VitalWireDelay (RSTP_ipd,        RSTP,        tipd_RSTP);
    VitalWireDelay (SUBTRACT_ipd,    SUBTRACT,    tipd_SUBTRACT);

  end block;


  SignalDelay : block
  begin
    A_Delay : for i in MSB_A downto 0 generate
        VitalSignalDelay (A_dly(i),     A_ipd(i),    tisd_A_CLK(i));  -- FP ??
    end generate A_Delay;

    B_Delay : for i in MSB_B downto 0 generate
        VitalSignalDelay (B_dly(i),     B_ipd(i),    tisd_B_CLK(i));  -- FP ??
    end generate B_Delay;

    BCIN_Delay : for i in MSB_BCIN downto 0 generate
        VitalSignalDelay (BCIN_dly(i),     BCIN_ipd(i),    tisd_BCIN_CLK(i));  -- FP ??
    end generate BCIN_Delay;

    C_Delay : for i in MSB_C downto 0 generate
        VitalSignalDelay (C_dly(i),     C_ipd(i),    tisd_C_CLK(i));  -- FP ??
    end generate C_Delay;

    VitalSignalDelay (CARRYIN_dly,    CARRYIN_ipd,    tisd_CARRYIN_CLK);

    CARRYINSEL_Delay : for i in MSB_CARRYINSEL downto 0 generate
        VitalSignalDelay (CARRYINSEL_dly(i),     CARRYINSEL_ipd(i),    tisd_CARRYINSEL_CLK(i));
    end generate CARRYINSEL_Delay;

    VitalSignalDelay (CEA_dly,        CEA_ipd,        tisd_CEA_CLK);
    VitalSignalDelay (CEB_dly,        CEB_ipd,        tisd_CEB_CLK);
    VitalSignalDelay (CEC_dly,        CEC_ipd,        tisd_CEC_CLK);
    VitalSignalDelay (CECARRYIN_dly,  CECARRYIN_ipd,  tisd_CECARRYIN_CLK);
    VitalSignalDelay (CECINSUB_dly,   CECINSUB_ipd,   tisd_CECINSUB_CLK);
    VitalSignalDelay (CECTRL_dly,     CECTRL_ipd,     tisd_CECTRL_CLK);
    VitalSignalDelay (CEM_dly,        CEM_ipd,        tisd_CEM_CLK);
    VitalSignalDelay (CEP_dly,        CEP_ipd,        tisd_CEP_CLK);

    VitalSignalDelay (CLK_dly,        CLK_ipd,        ticd_CLK);

    OPMODE_Delay : for i in MSB_OPMODE downto 0 generate
        VitalSignalDelay (OPMODE_dly(i),     OPMODE_ipd(i),    tisd_OPMODE_CLK(i));
    end generate OPMODE_Delay;

    PCIN_Delay : for i in MSB_PCIN downto 0 generate
        VitalSignalDelay (PCIN_dly(i),     PCIN_ipd(i),    tisd_PCIN_CLK(i));
    end generate PCIN_Delay;

    VitalSignalDelay (RSTA_dly,       RSTA_ipd,       tisd_RSTA_CLK);
    VitalSignalDelay (RSTB_dly,       RSTB_ipd,       tisd_RSTB_CLK);
    VitalSignalDelay (RSTC_dly,       RSTC_ipd,       tisd_RSTC_CLK);
    VitalSignalDelay (RSTCARRYIN_dly,   RSTCARRYIN_ipd,   tisd_RSTCARRYIN_CLK);
    VitalSignalDelay (RSTCTRL_dly,    RSTCTRL_ipd,    tisd_RSTCTRL_CLK);
    VitalSignalDelay (RSTM_dly,       RSTM_ipd,       tisd_RSTM_CLK);
    VitalSignalDelay (RSTP_dly,       RSTP_ipd,       tisd_RSTP_CLK);
    VitalSignalDelay (SUBTRACT_dly,   SUBTRACT_ipd,   tisd_SUBTRACT_CLK);


  end block;

  --------------------
  --  BEHAVIOR SECTION
  --------------------


--####################################################################
--#####                        Initialization                      ###
--####################################################################
 prcs_init:process
  begin
     if((LEGACY_MODE /="NONE") and (LEGACY_MODE /="MULT18X18") and 
        (LEGACY_MODE /="MULT18X18S")) then
        assert false
        report "Attribute Syntax Error: The allowed values for LEGACY_MODE are NONE, MULT18X18 or MULT18X18S."
        severity Failure;
     elsif((LEGACY_MODE ="MULT18X18") and (MREG /= 0)) then
        assert false
        report "Attribute Syntax Error: The attribute LEGACY_MODE on X_DSP48 is set to MULT18X18. This requires attribute MREG to be set to 0."
        severity Failure;
     elsif((LEGACY_MODE ="MULT18X18S") and (MREG /= 1)) then
        assert false
        report "Attribute Syntax Error: The attribute LEGACY_MODE on X_DSP48 is set to MULT18X18S. This requires attribute MREG to be set to 1."
        severity Failure;
     end if;

     wait; 
  end process prcs_init;
--####################################################################
--#####    Input Register A with two levels of registers and a mux ###
--####################################################################
  prcs_qa_2lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
          qa_o_reg1 <= ( others => '0');
          qa_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
--FP            if((RSTA_dly = '1') and (CEA_dly = '1')) then
            if(RSTA_dly = '1') then
               qa_o_reg1 <= ( others => '0');
               qa_o_reg2 <= ( others => '0');
            elsif ((RSTA_dly = '0') and  (CEA_dly = '1')) then
               qa_o_reg2 <= qa_o_reg1;
               qa_o_reg1 <= A_dly;
            end if;
         end if;
      end if;
  end process prcs_qa_2lvl;
------------------------------------------------------------------
  prcs_qa_o_mux:process(A_dly, qa_o_reg1, qa_o_reg2)
  begin
     case AREG is
       when 0 => qa_o_mux <= A_dly;
       when 1 => qa_o_mux <= qa_o_reg1;
       when 2 => qa_o_mux <= qa_o_reg2;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for AREG are 0 or 1 or 2"
            severity Failure;
     end case;
  end process prcs_qa_o_mux;

--####################################################################
--#####    Input Register B with two levels of registers and a mux ###
--####################################################################
 prcs_b_in:process(B_dly, BCIN_dly)
  begin
     if(B_INPUT ="DIRECT") then
        b_o_mux <= B_dly;
     elsif(B_INPUT ="CASCADE") then
        b_o_mux <= BCIN_dly;
     else
        assert false
        report "Attribute Syntax Error: The allowed values for B_INPUT are DIRECT or CASCADE."
        severity Failure;
     end if;
     
  end process prcs_b_in;
------------------------------------------------------------------
 prcs_qb_2lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
          qb_o_reg1 <= ( others => '0');
          qb_o_reg2 <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
-- FP            if((RSTB_dly = '1') and (CEB_dly = '1')) then
            if(RSTB_dly = '1') then
               qb_o_reg1 <= ( others => '0');
               qb_o_reg2 <= ( others => '0');
            elsif ((RSTB_dly = '0') and  (CEB_dly = '1')) then
               qb_o_reg2 <= qb_o_reg1;
               qb_o_reg1 <= b_o_mux;
            end if;
         end if;
      end if;
  end process prcs_qb_2lvl;
------------------------------------------------------------------
  prcs_qb_o_mux:process(b_o_mux, qb_o_reg1, qb_o_reg2)
  begin
     case BREG is
       when 0 => qb_o_mux <= b_o_mux;
       when 1 => qb_o_mux <= qb_o_reg1;
       when 2 => qb_o_mux <= qb_o_reg2;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for BREG are 0 or 1 or 2 "
            severity Failure;
     end case;

  end process prcs_qb_o_mux;

--####################################################################
--#####    Input Register C with 0, 1, level of registers        #####
--####################################################################
  prcs_qc_1lvl:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qc_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
-- FP           if((RSTC_dly = '1') and (CEC_dly = '1'))then
            if(RSTC_dly = '1') then
               qc_o_reg <= ( others => '0');
            elsif ((RSTC_dly = '0') and (CEC_dly = '1')) then
               qc_o_reg <= C_dly;
            end if;
         end if;
      end if;
  end process prcs_qc_1lvl;
------------------------------------------------------------------
  prcs_qc_o_mux:process(C_dly, qc_o_reg)
  begin
     case CREG is
      when 0 => qc_o_mux <= C_dly;
      when 1 => qc_o_mux <= qc_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for CREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_qc_o_mux;

--####################################################################
--#####                     Mulitplier                           #####
--####################################################################
  prcs_mult:process(qa_o_mux, qb_o_mux)
  begin
     mult_o_int <=  qa_o_mux * qb_o_mux;
  end process prcs_mult;
------------------------------------------------------------------
  prcs_mult_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         mult_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
--FP            if((RSTM_dly = '1') and (CEM_dly = '1'))then
            if(RSTM_dly = '1') then
               mult_o_reg <= ( others => '0');
            elsif ((RSTM_dly = '0') and (CEM_dly = '1')) then
               mult_o_reg <= mult_o_int;
            end if;
         end if;
      end if;
  end process prcs_mult_reg;
------------------------------------------------------------------
  prcs_mult_mux:process(mult_o_reg, mult_o_int)
  begin
     case MREG is
      when 0 => mult_o_mux <= mult_o_int;
      when 1 => mult_o_mux <= mult_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for MREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_mult_mux;

--####################################################################
--#####                        OpMode                            #####
--####################################################################
  prcs_opmode_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         opmode_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
--FP            if((RSTCTRL_dly = '1') and (CECTRL_dly = '1'))then
            if(RSTCTRL_dly = '1') then
               opmode_o_reg <= ( others => '0');
            elsif ((RSTCTRL_dly = '0') and (CECTRL_dly = '1')) then
               opmode_o_reg <= OPMODE_dly;
            end if;
         end if;
      end if;
  end process prcs_opmode_reg;
------------------------------------------------------------------
  prcs_opmode_mux:process(opmode_o_reg, OPMODE_dly)
  begin
     case OPMODEREG is
      when 0 => opmode_o_mux <= OPMODE_dly;
      when 1 => opmode_o_mux <= opmode_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for OPMODEREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_opmode_mux;
--####################################################################
--#####                        MUX_XYZ                           #####
--####################################################################
--  prcs_mux_xyz:process(opmode_o_mux,,,, FP)
      -- FP ?? more (Z) should be added to sensitivity list
  prcs_mux_xyz:process(opmode_o_mux, qp_o_mux, qa_o_mux, qb_o_mux, mult_o_mux, 
                       qc_o_mux, PCIN_dly, output_x_sig)
  begin
    if(output_x_sig = '1') then
      muxx_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxy_o_mux(MSB_P downto 0) <= ( others => 'X');
      muxz_o_mux(MSB_P downto 0) <= ( others => 'X');
    elsif(output_x_sig = '0') then
    --MUX_X -----
       case opmode_o_mux(1 downto 0) is
         when "00" => muxx_o_mux <= ( others => '0');
         -- FP ?? better way to concat ? and sign extend ?
         when "01" => muxx_o_mux((MAX_A + MAX_B - 1) downto 0) <= mult_o_mux;
                   if(mult_o_mux(MAX_A + MAX_B - 1) = '1') then
                     muxx_o_mux(MSB_PCIN downto (MAX_A + MAX_B)) <=  ( others => '1');
                   elsif (mult_o_mux(MSB_A + MSB_B + 1) = '0') then 
                     muxx_o_mux(MSB_PCIN downto (MAX_A + MAX_B)) <=  ( others => '0');
                   end if;

         when "10" => muxx_o_mux <= qp_o_mux;
         when "11" => if(qa_o_mux(MSB_A) = '0') then
                        muxx_o_mux(MSB_P downto 0)  <= ("000000000000" & qa_o_mux & qb_o_mux);
                      elsif(qa_o_mux(MSB_A) = '1') then
                        muxx_o_mux(MSB_P downto 0)  <= ("111111111111" & qa_o_mux & qb_o_mux);
                      end if;
--      when "11" => muxx_o_mux(MSB_B downto 0)  <= qb_o_mux;
--                   muxx_o_mux((MAX_A + MAX_B - 1) downto MAX_B) <= qa_o_mux;
--
--                  if(mult_o_mux(MAX_A + MAX_B - 1) = '1') then
--                     muxx_o_mux(MSB_PCIN downto (MAX_A + MAX_B)) <=  ( others => '1');
--                   elsif (mult_o_mux(MSB_A + MSB_B + 1) = '0') then
--                     muxx_o_mux(MSB_PCIN downto (MAX_A + MAX_B)) <=  ( others => '0');
--                   end if;
      when others => null;
--            assert false
--            report "Error: input signal OPMODE(1 downto 0) has unknown values"
--            severity Failure;
       end case;

    --MUX_Y -----
       case opmode_o_mux(3 downto 2) is
         when "00" => muxy_o_mux <= ( others => '0');
         when "01" => muxy_o_mux <= ( others => '0');
         when "10" => null;
         when "11" => muxy_o_mux <= qc_o_mux;
         when others => null;
--            assert false
--            report "Error: input signal OPMODE(3 downto 2) has unknown values"
--            severity Failure;
       end case;
    --MUX_Z -----
       case opmode_o_mux(6 downto 4) is
         when "000" => muxz_o_mux <= ( others => '0');
         when "001" => muxz_o_mux <= PCIN_dly;
         when "010" => muxz_o_mux <= qp_o_mux;
         when "011" => muxz_o_mux <= qc_o_mux;
         when "100" => null;
      -- FP ?? better shift possible ?
         when "101" => if(PCIN_dly(MSB_PCIN) = '0') then
                         muxz_o_mux  <= ( others => '0');
                       elsif(PCIN_dly(MSB_PCIN) = '1') then
                         muxz_o_mux  <= ( others => '1');
                       end if;
                       muxz_o_mux ((MSB_PCIN - SHIFT_MUXZ) downto 0) <= PCIN_dly(MSB_PCIN downto SHIFT_MUXZ ); 
         when "110" => if(qp_o_mux(MSB_P) = '0') then
                         muxz_o_mux  <= ( others => '0');
                       elsif(qp_o_mux(MSB_P) = '1') then
                         muxz_o_mux  <= ( others => '1');
                       end if;
--                    muxz_o_mux ((MAX_P - SHIFT_MUXZ) downto 0) <= qp_o_mux(MSB_P downto (SHIFT_MUXZ - 1)); 
                       muxz_o_mux ((MSB_P - SHIFT_MUXZ) downto 0) <= qp_o_mux(MSB_P downto SHIFT_MUXZ ); 
                      
         when "111" => null;
         when others => null;
--            assert false
--            report "Error: input signal OPMODE(6 downto 4) has unknown values"
--            severity Failure;
       end case;
    end if;
  end process prcs_mux_xyz;
--####################################################################
--#####                        Subtract                          #####
--####################################################################
  prcs_subtract_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         subtract_o_reg <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTCTRL_dly = '1') then
               subtract_o_reg <= '0';
            elsif ((RSTCTRL_dly = '0') and (CECINSUB_dly = '1'))then
               subtract_o_reg <= SUBTRACT_dly;
            end if;
         end if;
      end if;
  end process prcs_subtract_reg;
------------------------------------------------------------------
  prcs_subtract_mux:process(subtract_o_reg, SUBTRACT_dly)
  begin
     case SUBTRACTREG is
      when 0 => subtract_o_mux <= SUBTRACT_dly;
      when 1 => subtract_o_mux <= subtract_o_reg;
      when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for SUBTRACTREG are 0 or 1"
           severity Failure;
      end case;
  end process prcs_subtract_mux;

--####################################################################
--#####                     CarryInSel                           #####
--####################################################################
  prcs_carryinsel_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         carryinsel_o_reg <= ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
--FP            if((RSTCTRL_dly = '1') and (CECTRL_dly = '1'))then
            if(RSTCTRL_dly = '1') then
               carryinsel_o_reg <= ( others => '0');
            elsif ((RSTCTRL_dly = '0') and (CECTRL_dly = '1')) then
               carryinsel_o_reg <= CARRYINSEL_dly;
            end if;
         end if;
      end if;
  end process prcs_carryinsel_reg;
------------------------------------------------------------------
  prcs_carryinsel_mux:process(carryinsel_o_reg, CARRYINSEL_dly)
  begin
     case CARRYINSELREG is
       when 0 => carryinsel_o_mux <= CARRYINSEL_dly;
       when 1 => carryinsel_o_mux <= carryinsel_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for CARRYINSELREG are 0 or 1"
           severity Failure;
     end case;
  end process prcs_carryinsel_mux;

--####################################################################
--#####                       CarryIn                            #####
--####################################################################
  prcs_carryin_reg1:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qcarryin_o_reg1 <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTCARRYIN_dly = '1') then
               qcarryin_o_reg1 <= '0';
            elsif((RSTCARRYIN_dly = '0') and (CECINSUB_dly = '1')) then
               qcarryin_o_reg1 <= CARRYIN_dly;
            end if;
         end if;
      end if;
  end process prcs_carryin_reg1;
------------------------------------------------------------------
  prcs_carryin0_mux:process(qcarryin_o_reg1, CARRYIN_dly)
  begin
     case CARRYINREG is
       when 0 => carryin0_o_mux <= CARRYIN_dly;
       when 1 => carryin0_o_mux <= qcarryin_o_reg1;
       when others =>
            assert false
            report "Attribute Syntax Error: The allowed values for CARRYINREG are 0 or 1"
            severity Failure;
     end case;
  end process prcs_carryin0_mux;
------------------------------------------------------------------
  prcs_carryin1_mux:process(opmode_o_mux(0), opmode_o_mux(1), qa_o_mux(17), qb_o_mux(17))
  begin
     case (opmode_o_mux(0) and opmode_o_mux(1)) is
       when '0' => carryin1_o_mux <= NOT(qa_o_mux(17) xor qb_o_mux(17));
       when '1' => carryin1_o_mux <= NOT qa_o_mux(17);
       when others => null;
--           assert false
--           report "Error: UNKOWN Value at PORT OPMODE(1) "
--           severity Failure;
     end case;
  end process prcs_carryin1_mux;
------------------------------------------------------------------
  prcs_carryin2_mux:process(opmode_o_mux(0), opmode_o_mux(1), qp_o_mux(47), PCIN_dly(47))
  begin
     if(((opmode_o_mux(1) = '1') and (opmode_o_mux(0) = '0')) or 
        (opmode_o_mux(5) = '1') or 
        (NOT ((opmode_o_mux(6) = '1') or (opmode_o_mux(4) = '1')))) then
        carryin2_o_mux <= NOT qp_o_mux(47);
     else
        carryin2_o_mux <= NOT PCIN_dly(47);
     end if;
  end process prcs_carryin2_mux;
------------------------------------------------------------------
  prcs_carryin_reg2:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qcarryin_o_reg2 <= '0';
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTCARRYIN_dly = '1') then
               qcarryin_o_reg2 <= '0';
            elsif ((RSTCARRYIN_dly = '0') and (CECARRYIN_dly = '1'))then
               qcarryin_o_reg2 <= carryin1_o_mux;
            end if;
         end if;
      end if;
  end process prcs_carryin_reg2;
------------------------------------------------------------------
  prcs_carryin_mux:process(carryinsel_o_mux, carryin0_o_mux, carryin1_o_mux, carryin2_o_mux, qcarryin_o_reg2)
  begin
     case carryinsel_o_mux is
       when "00" => carryin_o_mux  <= carryin0_o_mux;
       when "01" => carryin_o_mux  <= carryin2_o_mux;
       when "10" => carryin_o_mux  <= carryin1_o_mux;
       when "11" => carryin_o_mux  <= qcarryin_o_reg2;
       when others => null;
--           assert false
--           report "Error: UNKOWN Value at carryinsel_o_mux"
--           severity Failure;
     end case;
  end process prcs_carryin_mux;
--####################################################################
--#####                       ACCUM                              #####
--####################################################################
--
--  NOTE :  moved it to the drc process
--
--  prcs_accum_xyz:process(muxx_o_mux, muxy_o_mux, muxz_o_mux, subtract_o_mux, carryin_o_mux )
--  variable carry_var : integer;
--  begin
--       if(carryin_o_mux = '1') then
--          carry_var := 1;
--       elsif (carryin_o_mux = '0') then 
--          carry_var := 0;
----       else
----          assert false
----          report "Error : CarryIn has Unknown value."
----          severity Failure;
--       end if;
          
--       if(subtract_o_mux = '0') then
--         accum_o <=  muxz_o_mux + (muxx_o_mux + muxy_o_mux + carryin_o_mux); 
--       elsif(subtract_o_mux = '1') then
--         accum_o <=  muxz_o_mux - (muxx_o_mux + muxy_o_mux + carryin_o_mux); 
----       else
----          assert false
----          report "Error : Subtract has Unknown value."
----          severity Failure;
--       end if;
--  end process prcs_accum_xyz;
--####################################################################
--#####                       PCOUT                               #####
--####################################################################
  prcs_qp_reg:process(CLK_dly, GSR_dly)
  begin
      if(GSR_dly = '1') then
         qp_o_reg <=  ( others => '0');
      elsif (GSR_dly = '0') then
         if(rising_edge(CLK_dly)) then
            if(RSTP_dly = '1') then
               qp_o_reg <= ( others => '0');
            elsif ((RSTP_dly = '0') and (CEP_dly = '1')) then
               qp_o_reg <= accum_o;
            end if;
         end if;
      end if;
  end process prcs_qp_reg;
------------------------------------------------------------------
  prcs_qp_mux:process(accum_o, qp_o_reg)
  begin
     case PREG is
       when 0 => qp_o_mux <= accum_o;
       when 1 => qp_o_mux <= qp_o_reg;
       when others =>
           assert false
           report "Attribute Syntax Error: The allowed values for PREG are 0 or 1"
           severity Failure;
     end case;
   
  end process prcs_qp_mux;
--####################################################################
--#####                   ZERO_DELAY_OUTPUTS                     #####
--####################################################################
  prcs_zero_delay_outputs:process(qb_o_mux, qp_o_mux)
  begin
    BCOUT_zd <= qb_o_mux;
    P_zd     <= qp_o_mux;
    PCOUT_zd <= qp_o_mux;
  end process prcs_zero_delay_outputs;

--####################################################################
--#####                 PMODE DRC                                #####
--####################################################################
  prcs_opmode_drc:process(opmode_o_mux, carryinsel_o_mux, subtract_o_mux,
                       muxx_o_mux, muxy_o_mux, muxz_o_mux, carryin_o_mux)
  variable Message : line;
  variable invalid_opmode_flg : boolean := true;
  variable add_flg : boolean := true;
  variable opmode_carryinsel_var : std_logic_vector(8 downto 0) := (others => '0');
  begin
--    if now > 100 ns then
--    The above line was cusing the intial values of A, B or C not trigger
      opmode_carryinsel_var := opmode_o_mux & carryinsel_o_mux;
      case opmode_carryinsel_var is


        when "000000000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "000001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;
-- CR 455601 eased the following drc 
        when "000001001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;
--

        when "000001100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "000010100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "000110000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "000111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "000111001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "000111100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "000111110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

-- CR 479833 eased the following drc 
        when "000111111" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';
--
        when "001000000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "001001001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "001001100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001001101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001001110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001010100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001010101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001010110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001010111" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001110000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001110001" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "001111001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "001111100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001111101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "001111110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "010000000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010111001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "010111110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011000000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "011001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011001001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011001100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "011001110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "011010100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "011010110" => 
                          if (MREG /= 0) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_no_mreg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011010111" => 
                          if (MREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_mreg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011110000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "011111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "011111100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';


        when "011111101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101000000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "101001100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101001101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101001110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101010100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101010101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101010110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101010111" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101110000" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101110001" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "101111001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "101111100" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101111101" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "101111110" => 
                          invalid_opmode_flg := true ;
                          add_flg := true ;
                          output_x_sig <= '0';

        when "110000000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110001000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110001100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110001101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110010100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110010101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110110000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110110001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110111000" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110111001" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110111100" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110111101" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;

        when "110111110" => 
                          if (PREG /= 1) then
                             accum_o <= (others => 'X');
                             add_flg := false;
                             if(invalid_opmode_flg) then
                                invalid_opmode_preg_msg(slv_to_str(opmode_o_mux), slv_to_str(carryinsel_o_mux));
                             end if;
                             invalid_opmode_flg := false;
                          else
                             invalid_opmode_flg := true;
                             add_flg := true;
                             output_x_sig <= '0';
                          end if;
        when others    =>
                       if(invalid_opmode_flg = true) then
                          invalid_opmode_flg := false;
                          add_flg := false;
                          output_x_sig <= '1';
                          accum_o <= (others => 'X');
                          Write ( Message, string'("OPMODE Input Warning : The OPMODE "));
                          Write ( Message,  slv_to_str(opmode_o_mux));
                          Write ( Message, string'(" with CARRYINSEL  "));
                          Write ( Message,  slv_to_str(carryinsel_o_mux));
                          Write ( Message, string'(" to DSP48 instance"));
                          Write ( Message, string'(" is invalid."));
                          assert false report Message.all severity Warning;
                          DEALLOCATE (Message);
                        end if;
      end case;


      if(add_flg) then 
         if(subtract_o_mux = '0') then
            accum_o <=  muxz_o_mux + (muxx_o_mux + muxy_o_mux + carryin_o_mux);
         elsif(subtract_o_mux = '1') then
            accum_o <=  muxz_o_mux - (muxx_o_mux + muxy_o_mux + carryin_o_mux);
         end if;
      end if;
--    end if;
  end process prcs_opmode_drc;

--####################################################################
--#####                   TIMING CHECKS                          #####
--####################################################################
  prcs_tmngchk:process
    variable P_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );
    variable PCOUT_GlitchData :  VitalGlitchDataArrayType (47 downto 0 );
    variable BCOUT_GlitchData :  VitalGlitchDataArrayType (17 downto 0 );

--  Pin timing violations (clock input pins)

--  Pin Timing Violations (all input pins)

    variable Tmkr_A_CLK_posedge  : VitalTimingDataArrayType(17 downto 0 );
    variable Tviol_A_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');

    variable Tmkr_B_CLK_posedge  : VitalTimingDataArrayType(17 downto 0 );
    variable Tviol_B_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');

    variable Tmkr_BCIN_CLK_posedge  : VitalTimingDataArrayType(17 downto 0 );
    variable Tviol_BCIN_CLK_posedge : std_logic_vector(17 downto 0 ) := (others => '0');

    variable Tmkr_C_CLK_posedge  : VitalTimingDataArrayType(47 downto 0 );
    variable Tviol_C_CLK_posedge : std_logic_vector(47 downto 0 ) := (others => '0');

    variable Tmkr_CARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CARRYINSEL_CLK_posedge  : VitalTimingDataArrayType(1 downto 0 );
    variable Tviol_CARRYINSEL_CLK_posedge : std_logic_vector(1 downto 0 ) := (others => '0');

    variable Tmkr_CEA_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEA_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEB_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEB_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEC_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEC_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CECARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CECARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CECINSUB_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CECINSUB_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CECTRL_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CECTRL_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEM_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEM_CLK_posedge : std_ulogic := '0';

    variable Tmkr_CEP_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_CEP_CLK_posedge : std_ulogic := '0';

    variable Tmkr_OPMODE_CLK_posedge  : VitalTimingDataArrayType(6 downto 0 );
    variable Tviol_OPMODE_CLK_posedge : std_logic_vector(6 downto 0 ) := (others => '0');

    variable Tmkr_PCIN_CLK_posedge  : VitalTimingDataArrayType(47 downto 0 );
    variable Tviol_PCIN_CLK_posedge : std_logic_vector(47 downto 0 ) := (others => '0');

    variable Tmkr_RSTA_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTA_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTB_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTB_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTC_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTC_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTCARRYIN_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTCARRYIN_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTCTRL_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTCTRL_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTM_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTM_CLK_posedge : std_ulogic := '0';

    variable Tmkr_RSTP_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_RSTP_CLK_posedge : std_ulogic := '0';

    variable Tmkr_SUBTRACT_CLK_posedge  : VitalTimingDataType := VitalTimingDataInit;
    variable Tviol_SUBTRACT_CLK_posedge : std_ulogic := '0';
    variable PInfo_CLK : VitalPeriodDataType := VitalPeriodDataInit;
    variable Pviol_CLK : std_ulogic := '0';

--  Output Pin glitch declaration
     variable  PCOUT0_GlitchData : VitalGlitchDataType;
     variable  PCOUT1_GlitchData : VitalGlitchDataType;
     variable  PCOUT2_GlitchData : VitalGlitchDataType;
     variable  PCOUT3_GlitchData : VitalGlitchDataType;
     variable  PCOUT4_GlitchData : VitalGlitchDataType;
     variable  PCOUT5_GlitchData : VitalGlitchDataType;
     variable  PCOUT6_GlitchData : VitalGlitchDataType;
     variable  PCOUT7_GlitchData : VitalGlitchDataType;
     variable  PCOUT8_GlitchData : VitalGlitchDataType;
     variable  PCOUT9_GlitchData : VitalGlitchDataType;
     variable  PCOUT10_GlitchData : VitalGlitchDataType;
     variable  PCOUT11_GlitchData : VitalGlitchDataType;
     variable  PCOUT12_GlitchData : VitalGlitchDataType;
     variable  PCOUT13_GlitchData : VitalGlitchDataType;
     variable  PCOUT14_GlitchData : VitalGlitchDataType;
     variable  PCOUT15_GlitchData : VitalGlitchDataType;
     variable  PCOUT16_GlitchData : VitalGlitchDataType;
     variable  PCOUT17_GlitchData : VitalGlitchDataType;
     variable  PCOUT18_GlitchData : VitalGlitchDataType;
     variable  PCOUT19_GlitchData : VitalGlitchDataType;
     variable  PCOUT20_GlitchData : VitalGlitchDataType;
     variable  PCOUT21_GlitchData : VitalGlitchDataType;
     variable  PCOUT22_GlitchData : VitalGlitchDataType;
     variable  PCOUT23_GlitchData : VitalGlitchDataType;
     variable  PCOUT24_GlitchData : VitalGlitchDataType;
     variable  PCOUT25_GlitchData : VitalGlitchDataType;
     variable  PCOUT26_GlitchData : VitalGlitchDataType;
     variable  PCOUT27_GlitchData : VitalGlitchDataType;
     variable  PCOUT28_GlitchData : VitalGlitchDataType;
     variable  PCOUT29_GlitchData : VitalGlitchDataType;
     variable  PCOUT30_GlitchData : VitalGlitchDataType;
     variable  PCOUT31_GlitchData : VitalGlitchDataType;
     variable  PCOUT32_GlitchData : VitalGlitchDataType;
     variable  PCOUT33_GlitchData : VitalGlitchDataType;
     variable  PCOUT34_GlitchData : VitalGlitchDataType;
     variable  PCOUT35_GlitchData : VitalGlitchDataType;
     variable  PCOUT36_GlitchData : VitalGlitchDataType;
     variable  PCOUT37_GlitchData : VitalGlitchDataType;
     variable  PCOUT38_GlitchData : VitalGlitchDataType;
     variable  PCOUT39_GlitchData : VitalGlitchDataType;
     variable  PCOUT40_GlitchData : VitalGlitchDataType;
     variable  PCOUT41_GlitchData : VitalGlitchDataType;
     variable  PCOUT42_GlitchData : VitalGlitchDataType;
     variable  PCOUT43_GlitchData : VitalGlitchDataType;
     variable  PCOUT44_GlitchData : VitalGlitchDataType;
     variable  PCOUT45_GlitchData : VitalGlitchDataType;
     variable  PCOUT46_GlitchData : VitalGlitchDataType;
     variable  PCOUT47_GlitchData : VitalGlitchDataType;
     variable  P0_GlitchData : VitalGlitchDataType;
     variable  P1_GlitchData : VitalGlitchDataType;
     variable  P2_GlitchData : VitalGlitchDataType;
     variable  P3_GlitchData : VitalGlitchDataType;
     variable  P4_GlitchData : VitalGlitchDataType;
     variable  P5_GlitchData : VitalGlitchDataType;
     variable  P6_GlitchData : VitalGlitchDataType;
     variable  P7_GlitchData : VitalGlitchDataType;
     variable  P8_GlitchData : VitalGlitchDataType;
     variable  P9_GlitchData : VitalGlitchDataType;
     variable  P10_GlitchData : VitalGlitchDataType;
     variable  P11_GlitchData : VitalGlitchDataType;
     variable  P12_GlitchData : VitalGlitchDataType;
     variable  P13_GlitchData : VitalGlitchDataType;
     variable  P14_GlitchData : VitalGlitchDataType;
     variable  P15_GlitchData : VitalGlitchDataType;
     variable  P16_GlitchData : VitalGlitchDataType;
     variable  P17_GlitchData : VitalGlitchDataType;
     variable  P18_GlitchData : VitalGlitchDataType;
     variable  P19_GlitchData : VitalGlitchDataType;
     variable  P20_GlitchData : VitalGlitchDataType;
     variable  P21_GlitchData : VitalGlitchDataType;
     variable  P22_GlitchData : VitalGlitchDataType;
     variable  P23_GlitchData : VitalGlitchDataType;
     variable  P24_GlitchData : VitalGlitchDataType;
     variable  P25_GlitchData : VitalGlitchDataType;
     variable  P26_GlitchData : VitalGlitchDataType;
     variable  P27_GlitchData : VitalGlitchDataType;
     variable  P28_GlitchData : VitalGlitchDataType;
     variable  P29_GlitchData : VitalGlitchDataType;
     variable  P30_GlitchData : VitalGlitchDataType;
     variable  P31_GlitchData : VitalGlitchDataType;
     variable  P32_GlitchData : VitalGlitchDataType;
     variable  P33_GlitchData : VitalGlitchDataType;
     variable  P34_GlitchData : VitalGlitchDataType;
     variable  P35_GlitchData : VitalGlitchDataType;
     variable  P36_GlitchData : VitalGlitchDataType;
     variable  P37_GlitchData : VitalGlitchDataType;
     variable  P38_GlitchData : VitalGlitchDataType;
     variable  P39_GlitchData : VitalGlitchDataType;
     variable  P40_GlitchData : VitalGlitchDataType;
     variable  P41_GlitchData : VitalGlitchDataType;
     variable  P42_GlitchData : VitalGlitchDataType;
     variable  P43_GlitchData : VitalGlitchDataType;
     variable  P44_GlitchData : VitalGlitchDataType;
     variable  P45_GlitchData : VitalGlitchDataType;
     variable  P46_GlitchData : VitalGlitchDataType;
     variable  P47_GlitchData : VitalGlitchDataType;
     variable  BCOUT0_GlitchData : VitalGlitchDataType;
     variable  BCOUT1_GlitchData : VitalGlitchDataType;
     variable  BCOUT2_GlitchData : VitalGlitchDataType;
     variable  BCOUT3_GlitchData : VitalGlitchDataType;
     variable  BCOUT4_GlitchData : VitalGlitchDataType;
     variable  BCOUT5_GlitchData : VitalGlitchDataType;
     variable  BCOUT6_GlitchData : VitalGlitchDataType;
     variable  BCOUT7_GlitchData : VitalGlitchDataType;
     variable  BCOUT8_GlitchData : VitalGlitchDataType;
     variable  BCOUT9_GlitchData : VitalGlitchDataType;
     variable  BCOUT10_GlitchData : VitalGlitchDataType;
     variable  BCOUT11_GlitchData : VitalGlitchDataType;
     variable  BCOUT12_GlitchData : VitalGlitchDataType;
     variable  BCOUT13_GlitchData : VitalGlitchDataType;
     variable  BCOUT14_GlitchData : VitalGlitchDataType;
     variable  BCOUT15_GlitchData : VitalGlitchDataType;
     variable  BCOUT16_GlitchData : VitalGlitchDataType;
     variable  BCOUT17_GlitchData : VitalGlitchDataType;
begin

--  Setup/Hold Check Violations (all input pins)

     if (TimingChecksOn) then
--=====  Vital SetupHold Checks for Bus signal A =====
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(0),
         TimingData           => Tmkr_A_CLK_posedge(0),
         TestSignal           => A_dly(0),
         TestSignalName       => "A(0)",
         TestDelay            => tisd_A_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(0),
         SetupLow             => tsetup_A_CLK_negedge_posedge(0),
         HoldHigh             => thold_A_CLK_posedge_posedge(0),
         HoldLow              => thold_A_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(1),
         TimingData           => Tmkr_A_CLK_posedge(1),
         TestSignal           => A_dly(1),
         TestSignalName       => "A(1)",
         TestDelay            => tisd_A_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(1),
         SetupLow             => tsetup_A_CLK_negedge_posedge(1),
         HoldHigh             => thold_A_CLK_posedge_posedge(1),
         HoldLow              => thold_A_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(2),
         TimingData           => Tmkr_A_CLK_posedge(2),
         TestSignal           => A_dly(2),
         TestSignalName       => "A(2)",
         TestDelay            => tisd_A_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(2),
         SetupLow             => tsetup_A_CLK_negedge_posedge(2),
         HoldHigh             => thold_A_CLK_posedge_posedge(2),
         HoldLow              => thold_A_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(3),
         TimingData           => Tmkr_A_CLK_posedge(3),
         TestSignal           => A_dly(3),
         TestSignalName       => "A(3)",
         TestDelay            => tisd_A_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(3),
         SetupLow             => tsetup_A_CLK_negedge_posedge(3),
         HoldHigh             => thold_A_CLK_posedge_posedge(3),
         HoldLow              => thold_A_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(4),
         TimingData           => Tmkr_A_CLK_posedge(4),
         TestSignal           => A_dly(4),
         TestSignalName       => "A(4)",
         TestDelay            => tisd_A_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(4),
         SetupLow             => tsetup_A_CLK_negedge_posedge(4),
         HoldHigh             => thold_A_CLK_posedge_posedge(4),
         HoldLow              => thold_A_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(5),
         TimingData           => Tmkr_A_CLK_posedge(5),
         TestSignal           => A_dly(5),
         TestSignalName       => "A(5)",
         TestDelay            => tisd_A_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(5),
         SetupLow             => tsetup_A_CLK_negedge_posedge(5),
         HoldHigh             => thold_A_CLK_posedge_posedge(5),
         HoldLow              => thold_A_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(6),
         TimingData           => Tmkr_A_CLK_posedge(6),
         TestSignal           => A_dly(6),
         TestSignalName       => "A(6)",
         TestDelay            => tisd_A_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(6),
         SetupLow             => tsetup_A_CLK_negedge_posedge(6),
         HoldHigh             => thold_A_CLK_posedge_posedge(6),
         HoldLow              => thold_A_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(7),
         TimingData           => Tmkr_A_CLK_posedge(7),
         TestSignal           => A_dly(7),
         TestSignalName       => "A(7)",
         TestDelay            => tisd_A_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(7),
         SetupLow             => tsetup_A_CLK_negedge_posedge(7),
         HoldHigh             => thold_A_CLK_posedge_posedge(7),
         HoldLow              => thold_A_CLK_negedge_posedge(7),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(8),
         TimingData           => Tmkr_A_CLK_posedge(8),
         TestSignal           => A_dly(8),
         TestSignalName       => "A(8)",
         TestDelay            => tisd_A_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(8),
         SetupLow             => tsetup_A_CLK_negedge_posedge(8),
         HoldHigh             => thold_A_CLK_posedge_posedge(8),
         HoldLow              => thold_A_CLK_negedge_posedge(8),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(9),
         TimingData           => Tmkr_A_CLK_posedge(9),
         TestSignal           => A_dly(9),
         TestSignalName       => "A(9)",
         TestDelay            => tisd_A_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(9),
         SetupLow             => tsetup_A_CLK_negedge_posedge(9),
         HoldHigh             => thold_A_CLK_posedge_posedge(9),
         HoldLow              => thold_A_CLK_negedge_posedge(9),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(10),
         TimingData           => Tmkr_A_CLK_posedge(10),
         TestSignal           => A_dly(10),
         TestSignalName       => "A(10)",
         TestDelay            => tisd_A_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(10),
         SetupLow             => tsetup_A_CLK_negedge_posedge(10),
         HoldHigh             => thold_A_CLK_posedge_posedge(10),
         HoldLow              => thold_A_CLK_negedge_posedge(10),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(11),
         TimingData           => Tmkr_A_CLK_posedge(11),
         TestSignal           => A_dly(11),
         TestSignalName       => "A(11)",
         TestDelay            => tisd_A_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(11),
         SetupLow             => tsetup_A_CLK_negedge_posedge(11),
         HoldHigh             => thold_A_CLK_posedge_posedge(11),
         HoldLow              => thold_A_CLK_negedge_posedge(11),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(12),
         TimingData           => Tmkr_A_CLK_posedge(12),
         TestSignal           => A_dly(12),
         TestSignalName       => "A(12)",
         TestDelay            => tisd_A_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(12),
         SetupLow             => tsetup_A_CLK_negedge_posedge(12),
         HoldHigh             => thold_A_CLK_posedge_posedge(12),
         HoldLow              => thold_A_CLK_negedge_posedge(12),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(13),
         TimingData           => Tmkr_A_CLK_posedge(13),
         TestSignal           => A_dly(13),
         TestSignalName       => "A(13)",
         TestDelay            => tisd_A_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(13),
         SetupLow             => tsetup_A_CLK_negedge_posedge(13),
         HoldHigh             => thold_A_CLK_posedge_posedge(13),
         HoldLow              => thold_A_CLK_negedge_posedge(13),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(14),
         TimingData           => Tmkr_A_CLK_posedge(14),
         TestSignal           => A_dly(14),
         TestSignalName       => "A(14)",
         TestDelay            => tisd_A_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(14),
         SetupLow             => tsetup_A_CLK_negedge_posedge(14),
         HoldHigh             => thold_A_CLK_posedge_posedge(14),
         HoldLow              => thold_A_CLK_negedge_posedge(14),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(15),
         TimingData           => Tmkr_A_CLK_posedge(15),
         TestSignal           => A_dly(15),
         TestSignalName       => "A(15)",
         TestDelay            => tisd_A_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(15),
         SetupLow             => tsetup_A_CLK_negedge_posedge(15),
         HoldHigh             => thold_A_CLK_posedge_posedge(15),
         HoldLow              => thold_A_CLK_negedge_posedge(15),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(16),
         TimingData           => Tmkr_A_CLK_posedge(16),
         TestSignal           => A_dly(16),
         TestSignalName       => "A(16)",
         TestDelay            => tisd_A_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(16),
         SetupLow             => tsetup_A_CLK_negedge_posedge(16),
         HoldHigh             => thold_A_CLK_posedge_posedge(16),
         HoldLow              => thold_A_CLK_negedge_posedge(16),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_A_CLK_posedge(17),
         TimingData           => Tmkr_A_CLK_posedge(17),
         TestSignal           => A_dly(17),
         TestSignalName       => "A(17)",
         TestDelay            => tisd_A_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_A_CLK_posedge_posedge(17),
         SetupLow             => tsetup_A_CLK_negedge_posedge(17),
         HoldHigh             => thold_A_CLK_posedge_posedge(17),
         HoldLow              => thold_A_CLK_negedge_posedge(17),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (CEA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal B =====
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(0),
         TimingData           => Tmkr_B_CLK_posedge(0),
         TestSignal           => B_dly(0),
         TestSignalName       => "B(0)",
         TestDelay            => tisd_B_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(0),
         SetupLow             => tsetup_B_CLK_negedge_posedge(0),
         HoldHigh             => thold_B_CLK_posedge_posedge(0),
         HoldLow              => thold_B_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(1),
         TimingData           => Tmkr_B_CLK_posedge(1),
         TestSignal           => B_dly(1),
         TestSignalName       => "B(1)",
         TestDelay            => tisd_B_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(1),
         SetupLow             => tsetup_B_CLK_negedge_posedge(1),
         HoldHigh             => thold_B_CLK_posedge_posedge(1),
         HoldLow              => thold_B_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(2),
         TimingData           => Tmkr_B_CLK_posedge(2),
         TestSignal           => B_dly(2),
         TestSignalName       => "B(2)",
         TestDelay            => tisd_B_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(2),
         SetupLow             => tsetup_B_CLK_negedge_posedge(2),
         HoldHigh             => thold_B_CLK_posedge_posedge(2),
         HoldLow              => thold_B_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(3),
         TimingData           => Tmkr_B_CLK_posedge(3),
         TestSignal           => B_dly(3),
         TestSignalName       => "B(3)",
         TestDelay            => tisd_B_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(3),
         SetupLow             => tsetup_B_CLK_negedge_posedge(3),
         HoldHigh             => thold_B_CLK_posedge_posedge(3),
         HoldLow              => thold_B_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(4),
         TimingData           => Tmkr_B_CLK_posedge(4),
         TestSignal           => B_dly(4),
         TestSignalName       => "B(4)",
         TestDelay            => tisd_B_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(4),
         SetupLow             => tsetup_B_CLK_negedge_posedge(4),
         HoldHigh             => thold_B_CLK_posedge_posedge(4),
         HoldLow              => thold_B_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(5),
         TimingData           => Tmkr_B_CLK_posedge(5),
         TestSignal           => B_dly(5),
         TestSignalName       => "B(5)",
         TestDelay            => tisd_B_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(5),
         SetupLow             => tsetup_B_CLK_negedge_posedge(5),
         HoldHigh             => thold_B_CLK_posedge_posedge(5),
         HoldLow              => thold_B_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(6),
         TimingData           => Tmkr_B_CLK_posedge(6),
         TestSignal           => B_dly(6),
         TestSignalName       => "B(6)",
         TestDelay            => tisd_B_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(6),
         SetupLow             => tsetup_B_CLK_negedge_posedge(6),
         HoldHigh             => thold_B_CLK_posedge_posedge(6),
         HoldLow              => thold_B_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(7),
         TimingData           => Tmkr_B_CLK_posedge(7),
         TestSignal           => B_dly(7),
         TestSignalName       => "B(7)",
         TestDelay            => tisd_B_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(7),
         SetupLow             => tsetup_B_CLK_negedge_posedge(7),
         HoldHigh             => thold_B_CLK_posedge_posedge(7),
         HoldLow              => thold_B_CLK_negedge_posedge(7),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(8),
         TimingData           => Tmkr_B_CLK_posedge(8),
         TestSignal           => B_dly(8),
         TestSignalName       => "B(8)",
         TestDelay            => tisd_B_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(8),
         SetupLow             => tsetup_B_CLK_negedge_posedge(8),
         HoldHigh             => thold_B_CLK_posedge_posedge(8),
         HoldLow              => thold_B_CLK_negedge_posedge(8),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(9),
         TimingData           => Tmkr_B_CLK_posedge(9),
         TestSignal           => B_dly(9),
         TestSignalName       => "B(9)",
         TestDelay            => tisd_B_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(9),
         SetupLow             => tsetup_B_CLK_negedge_posedge(9),
         HoldHigh             => thold_B_CLK_posedge_posedge(9),
         HoldLow              => thold_B_CLK_negedge_posedge(9),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(10),
         TimingData           => Tmkr_B_CLK_posedge(10),
         TestSignal           => B_dly(10),
         TestSignalName       => "B(10)",
         TestDelay            => tisd_B_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(10),
         SetupLow             => tsetup_B_CLK_negedge_posedge(10),
         HoldHigh             => thold_B_CLK_posedge_posedge(10),
         HoldLow              => thold_B_CLK_negedge_posedge(10),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(11),
         TimingData           => Tmkr_B_CLK_posedge(11),
         TestSignal           => B_dly(11),
         TestSignalName       => "B(11)",
         TestDelay            => tisd_B_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(11),
         SetupLow             => tsetup_B_CLK_negedge_posedge(11),
         HoldHigh             => thold_B_CLK_posedge_posedge(11),
         HoldLow              => thold_B_CLK_negedge_posedge(11),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(12),
         TimingData           => Tmkr_B_CLK_posedge(12),
         TestSignal           => B_dly(12),
         TestSignalName       => "B(12)",
         TestDelay            => tisd_B_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(12),
         SetupLow             => tsetup_B_CLK_negedge_posedge(12),
         HoldHigh             => thold_B_CLK_posedge_posedge(12),
         HoldLow              => thold_B_CLK_negedge_posedge(12),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(13),
         TimingData           => Tmkr_B_CLK_posedge(13),
         TestSignal           => B_dly(13),
         TestSignalName       => "B(13)",
         TestDelay            => tisd_B_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(13),
         SetupLow             => tsetup_B_CLK_negedge_posedge(13),
         HoldHigh             => thold_B_CLK_posedge_posedge(13),
         HoldLow              => thold_B_CLK_negedge_posedge(13),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(14),
         TimingData           => Tmkr_B_CLK_posedge(14),
         TestSignal           => B_dly(14),
         TestSignalName       => "B(14)",
         TestDelay            => tisd_B_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(14),
         SetupLow             => tsetup_B_CLK_negedge_posedge(14),
         HoldHigh             => thold_B_CLK_posedge_posedge(14),
         HoldLow              => thold_B_CLK_negedge_posedge(14),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(15),
         TimingData           => Tmkr_B_CLK_posedge(15),
         TestSignal           => B_dly(15),
         TestSignalName       => "B(15)",
         TestDelay            => tisd_B_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(15),
         SetupLow             => tsetup_B_CLK_negedge_posedge(15),
         HoldHigh             => thold_B_CLK_posedge_posedge(15),
         HoldLow              => thold_B_CLK_negedge_posedge(15),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(16),
         TimingData           => Tmkr_B_CLK_posedge(16),
         TestSignal           => B_dly(16),
         TestSignalName       => "B(16)",
         TestDelay            => tisd_B_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(16),
         SetupLow             => tsetup_B_CLK_negedge_posedge(16),
         HoldHigh             => thold_B_CLK_posedge_posedge(16),
         HoldLow              => thold_B_CLK_negedge_posedge(16),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_B_CLK_posedge(17),
         TimingData           => Tmkr_B_CLK_posedge(17),
         TestSignal           => B_dly(17),
         TestSignalName       => "B(17)",
         TestDelay            => tisd_B_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_B_CLK_posedge_posedge(17),
         SetupLow             => tsetup_B_CLK_negedge_posedge(17),
         HoldHigh             => thold_B_CLK_posedge_posedge(17),
         HoldLow              => thold_B_CLK_negedge_posedge(17),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal BCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(0),
         TimingData           => Tmkr_BCIN_CLK_posedge(0),
         TestSignal           => BCIN_dly(0),
         TestSignalName       => "BCIN(0)",
         TestDelay            => tisd_BCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(1),
         TimingData           => Tmkr_BCIN_CLK_posedge(1),
         TestSignal           => BCIN_dly(1),
         TestSignalName       => "BCIN(1)",
         TestDelay            => tisd_BCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(2),
         TimingData           => Tmkr_BCIN_CLK_posedge(2),
         TestSignal           => BCIN_dly(2),
         TestSignalName       => "BCIN(2)",
         TestDelay            => tisd_BCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(3),
         TimingData           => Tmkr_BCIN_CLK_posedge(3),
         TestSignal           => BCIN_dly(3),
         TestSignalName       => "BCIN(3)",
         TestDelay            => tisd_BCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(4),
         TimingData           => Tmkr_BCIN_CLK_posedge(4),
         TestSignal           => BCIN_dly(4),
         TestSignalName       => "BCIN(4)",
         TestDelay            => tisd_BCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(5),
         TimingData           => Tmkr_BCIN_CLK_posedge(5),
         TestSignal           => BCIN_dly(5),
         TestSignalName       => "BCIN(5)",
         TestDelay            => tisd_BCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(6),
         TimingData           => Tmkr_BCIN_CLK_posedge(6),
         TestSignal           => BCIN_dly(6),
         TestSignalName       => "BCIN(6)",
         TestDelay            => tisd_BCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(7),
         TimingData           => Tmkr_BCIN_CLK_posedge(7),
         TestSignal           => BCIN_dly(7),
         TestSignalName       => "BCIN(7)",
         TestDelay            => tisd_BCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(7),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(8),
         TimingData           => Tmkr_BCIN_CLK_posedge(8),
         TestSignal           => BCIN_dly(8),
         TestSignalName       => "BCIN(8)",
         TestDelay            => tisd_BCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(8),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(9),
         TimingData           => Tmkr_BCIN_CLK_posedge(9),
         TestSignal           => BCIN_dly(9),
         TestSignalName       => "BCIN(9)",
         TestDelay            => tisd_BCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(9),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(10),
         TimingData           => Tmkr_BCIN_CLK_posedge(10),
         TestSignal           => BCIN_dly(10),
         TestSignalName       => "BCIN(10)",
         TestDelay            => tisd_BCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(10),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(11),
         TimingData           => Tmkr_BCIN_CLK_posedge(11),
         TestSignal           => BCIN_dly(11),
         TestSignalName       => "BCIN(11)",
         TestDelay            => tisd_BCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(11),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(12),
         TimingData           => Tmkr_BCIN_CLK_posedge(12),
         TestSignal           => BCIN_dly(12),
         TestSignalName       => "BCIN(12)",
         TestDelay            => tisd_BCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(12),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(13),
         TimingData           => Tmkr_BCIN_CLK_posedge(13),
         TestSignal           => BCIN_dly(13),
         TestSignalName       => "BCIN(13)",
         TestDelay            => tisd_BCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(13),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(14),
         TimingData           => Tmkr_BCIN_CLK_posedge(14),
         TestSignal           => BCIN_dly(14),
         TestSignalName       => "BCIN(14)",
         TestDelay            => tisd_BCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(14),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(15),
         TimingData           => Tmkr_BCIN_CLK_posedge(15),
         TestSignal           => BCIN_dly(15),
         TestSignalName       => "BCIN(15)",
         TestDelay            => tisd_BCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(15),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(16),
         TimingData           => Tmkr_BCIN_CLK_posedge(16),
         TestSignal           => BCIN_dly(16),
         TestSignalName       => "BCIN(16)",
         TestDelay            => tisd_BCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(16),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_BCIN_CLK_posedge(17),
         TimingData           => Tmkr_BCIN_CLK_posedge(17),
         TestSignal           => BCIN_dly(17),
         TestSignalName       => "BCIN(17)",
         TestDelay            => tisd_BCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_BCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_BCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_BCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_BCIN_CLK_negedge_posedge(17),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal C =====
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(0),
         TimingData           => Tmkr_C_CLK_posedge(0),
         TestSignal           => C_dly(0),
         TestSignalName       => "C(0)",
         TestDelay            => tisd_C_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(0),
         SetupLow             => tsetup_C_CLK_negedge_posedge(0),
         HoldHigh             => thold_C_CLK_posedge_posedge(0),
         HoldLow              => thold_C_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(1),
         TimingData           => Tmkr_C_CLK_posedge(1),
         TestSignal           => C_dly(1),
         TestSignalName       => "C(1)",
         TestDelay            => tisd_C_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(1),
         SetupLow             => tsetup_C_CLK_negedge_posedge(1),
         HoldHigh             => thold_C_CLK_posedge_posedge(1),
         HoldLow              => thold_C_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(2),
         TimingData           => Tmkr_C_CLK_posedge(2),
         TestSignal           => C_dly(2),
         TestSignalName       => "C(2)",
         TestDelay            => tisd_C_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(2),
         SetupLow             => tsetup_C_CLK_negedge_posedge(2),
         HoldHigh             => thold_C_CLK_posedge_posedge(2),
         HoldLow              => thold_C_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(3),
         TimingData           => Tmkr_C_CLK_posedge(3),
         TestSignal           => C_dly(3),
         TestSignalName       => "C(3)",
         TestDelay            => tisd_C_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(3),
         SetupLow             => tsetup_C_CLK_negedge_posedge(3),
         HoldHigh             => thold_C_CLK_posedge_posedge(3),
         HoldLow              => thold_C_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(4),
         TimingData           => Tmkr_C_CLK_posedge(4),
         TestSignal           => C_dly(4),
         TestSignalName       => "C(4)",
         TestDelay            => tisd_C_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(4),
         SetupLow             => tsetup_C_CLK_negedge_posedge(4),
         HoldHigh             => thold_C_CLK_posedge_posedge(4),
         HoldLow              => thold_C_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(5),
         TimingData           => Tmkr_C_CLK_posedge(5),
         TestSignal           => C_dly(5),
         TestSignalName       => "C(5)",
         TestDelay            => tisd_C_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(5),
         SetupLow             => tsetup_C_CLK_negedge_posedge(5),
         HoldHigh             => thold_C_CLK_posedge_posedge(5),
         HoldLow              => thold_C_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(6),
         TimingData           => Tmkr_C_CLK_posedge(6),
         TestSignal           => C_dly(6),
         TestSignalName       => "C(6)",
         TestDelay            => tisd_C_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(6),
         SetupLow             => tsetup_C_CLK_negedge_posedge(6),
         HoldHigh             => thold_C_CLK_posedge_posedge(6),
         HoldLow              => thold_C_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(7),
         TimingData           => Tmkr_C_CLK_posedge(7),
         TestSignal           => C_dly(7),
         TestSignalName       => "C(7)",
         TestDelay            => tisd_C_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(7),
         SetupLow             => tsetup_C_CLK_negedge_posedge(7),
         HoldHigh             => thold_C_CLK_posedge_posedge(7),
         HoldLow              => thold_C_CLK_negedge_posedge(7),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(8),
         TimingData           => Tmkr_C_CLK_posedge(8),
         TestSignal           => C_dly(8),
         TestSignalName       => "C(8)",
         TestDelay            => tisd_C_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(8),
         SetupLow             => tsetup_C_CLK_negedge_posedge(8),
         HoldHigh             => thold_C_CLK_posedge_posedge(8),
         HoldLow              => thold_C_CLK_negedge_posedge(8),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(9),
         TimingData           => Tmkr_C_CLK_posedge(9),
         TestSignal           => C_dly(9),
         TestSignalName       => "C(9)",
         TestDelay            => tisd_C_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(9),
         SetupLow             => tsetup_C_CLK_negedge_posedge(9),
         HoldHigh             => thold_C_CLK_posedge_posedge(9),
         HoldLow              => thold_C_CLK_negedge_posedge(9),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(10),
         TimingData           => Tmkr_C_CLK_posedge(10),
         TestSignal           => C_dly(10),
         TestSignalName       => "C(10)",
         TestDelay            => tisd_C_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(10),
         SetupLow             => tsetup_C_CLK_negedge_posedge(10),
         HoldHigh             => thold_C_CLK_posedge_posedge(10),
         HoldLow              => thold_C_CLK_negedge_posedge(10),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(11),
         TimingData           => Tmkr_C_CLK_posedge(11),
         TestSignal           => C_dly(11),
         TestSignalName       => "C(11)",
         TestDelay            => tisd_C_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(11),
         SetupLow             => tsetup_C_CLK_negedge_posedge(11),
         HoldHigh             => thold_C_CLK_posedge_posedge(11),
         HoldLow              => thold_C_CLK_negedge_posedge(11),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(12),
         TimingData           => Tmkr_C_CLK_posedge(12),
         TestSignal           => C_dly(12),
         TestSignalName       => "C(12)",
         TestDelay            => tisd_C_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(12),
         SetupLow             => tsetup_C_CLK_negedge_posedge(12),
         HoldHigh             => thold_C_CLK_posedge_posedge(12),
         HoldLow              => thold_C_CLK_negedge_posedge(12),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(13),
         TimingData           => Tmkr_C_CLK_posedge(13),
         TestSignal           => C_dly(13),
         TestSignalName       => "C(13)",
         TestDelay            => tisd_C_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(13),
         SetupLow             => tsetup_C_CLK_negedge_posedge(13),
         HoldHigh             => thold_C_CLK_posedge_posedge(13),
         HoldLow              => thold_C_CLK_negedge_posedge(13),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(14),
         TimingData           => Tmkr_C_CLK_posedge(14),
         TestSignal           => C_dly(14),
         TestSignalName       => "C(14)",
         TestDelay            => tisd_C_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(14),
         SetupLow             => tsetup_C_CLK_negedge_posedge(14),
         HoldHigh             => thold_C_CLK_posedge_posedge(14),
         HoldLow              => thold_C_CLK_negedge_posedge(14),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(15),
         TimingData           => Tmkr_C_CLK_posedge(15),
         TestSignal           => C_dly(15),
         TestSignalName       => "C(15)",
         TestDelay            => tisd_C_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(15),
         SetupLow             => tsetup_C_CLK_negedge_posedge(15),
         HoldHigh             => thold_C_CLK_posedge_posedge(15),
         HoldLow              => thold_C_CLK_negedge_posedge(15),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(16),
         TimingData           => Tmkr_C_CLK_posedge(16),
         TestSignal           => C_dly(16),
         TestSignalName       => "C(16)",
         TestDelay            => tisd_C_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(16),
         SetupLow             => tsetup_C_CLK_negedge_posedge(16),
         HoldHigh             => thold_C_CLK_posedge_posedge(16),
         HoldLow              => thold_C_CLK_negedge_posedge(16),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(17),
         TimingData           => Tmkr_C_CLK_posedge(17),
         TestSignal           => C_dly(17),
         TestSignalName       => "C(17)",
         TestDelay            => tisd_C_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(17),
         SetupLow             => tsetup_C_CLK_negedge_posedge(17),
         HoldHigh             => thold_C_CLK_posedge_posedge(17),
         HoldLow              => thold_C_CLK_negedge_posedge(17),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(18),
         TimingData           => Tmkr_C_CLK_posedge(18),
         TestSignal           => C_dly(18),
         TestSignalName       => "C(18)",
         TestDelay            => tisd_C_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(18),
         SetupLow             => tsetup_C_CLK_negedge_posedge(18),
         HoldHigh             => thold_C_CLK_posedge_posedge(18),
         HoldLow              => thold_C_CLK_negedge_posedge(18),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(19),
         TimingData           => Tmkr_C_CLK_posedge(19),
         TestSignal           => C_dly(19),
         TestSignalName       => "C(19)",
         TestDelay            => tisd_C_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(19),
         SetupLow             => tsetup_C_CLK_negedge_posedge(19),
         HoldHigh             => thold_C_CLK_posedge_posedge(19),
         HoldLow              => thold_C_CLK_negedge_posedge(19),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(20),
         TimingData           => Tmkr_C_CLK_posedge(20),
         TestSignal           => C_dly(20),
         TestSignalName       => "C(20)",
         TestDelay            => tisd_C_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(20),
         SetupLow             => tsetup_C_CLK_negedge_posedge(20),
         HoldHigh             => thold_C_CLK_posedge_posedge(20),
         HoldLow              => thold_C_CLK_negedge_posedge(20),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(21),
         TimingData           => Tmkr_C_CLK_posedge(21),
         TestSignal           => C_dly(21),
         TestSignalName       => "C(21)",
         TestDelay            => tisd_C_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(21),
         SetupLow             => tsetup_C_CLK_negedge_posedge(21),
         HoldHigh             => thold_C_CLK_posedge_posedge(21),
         HoldLow              => thold_C_CLK_negedge_posedge(21),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(22),
         TimingData           => Tmkr_C_CLK_posedge(22),
         TestSignal           => C_dly(22),
         TestSignalName       => "C(22)",
         TestDelay            => tisd_C_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(22),
         SetupLow             => tsetup_C_CLK_negedge_posedge(22),
         HoldHigh             => thold_C_CLK_posedge_posedge(22),
         HoldLow              => thold_C_CLK_negedge_posedge(22),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(23),
         TimingData           => Tmkr_C_CLK_posedge(23),
         TestSignal           => C_dly(23),
         TestSignalName       => "C(23)",
         TestDelay            => tisd_C_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(23),
         SetupLow             => tsetup_C_CLK_negedge_posedge(23),
         HoldHigh             => thold_C_CLK_posedge_posedge(23),
         HoldLow              => thold_C_CLK_negedge_posedge(23),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(24),
         TimingData           => Tmkr_C_CLK_posedge(24),
         TestSignal           => C_dly(24),
         TestSignalName       => "C(24)",
         TestDelay            => tisd_C_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(24),
         SetupLow             => tsetup_C_CLK_negedge_posedge(24),
         HoldHigh             => thold_C_CLK_posedge_posedge(24),
         HoldLow              => thold_C_CLK_negedge_posedge(24),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(25),
         TimingData           => Tmkr_C_CLK_posedge(25),
         TestSignal           => C_dly(25),
         TestSignalName       => "C(25)",
         TestDelay            => tisd_C_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(25),
         SetupLow             => tsetup_C_CLK_negedge_posedge(25),
         HoldHigh             => thold_C_CLK_posedge_posedge(25),
         HoldLow              => thold_C_CLK_negedge_posedge(25),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(26),
         TimingData           => Tmkr_C_CLK_posedge(26),
         TestSignal           => C_dly(26),
         TestSignalName       => "C(26)",
         TestDelay            => tisd_C_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(26),
         SetupLow             => tsetup_C_CLK_negedge_posedge(26),
         HoldHigh             => thold_C_CLK_posedge_posedge(26),
         HoldLow              => thold_C_CLK_negedge_posedge(26),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(27),
         TimingData           => Tmkr_C_CLK_posedge(27),
         TestSignal           => C_dly(27),
         TestSignalName       => "C(27)",
         TestDelay            => tisd_C_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(27),
         SetupLow             => tsetup_C_CLK_negedge_posedge(27),
         HoldHigh             => thold_C_CLK_posedge_posedge(27),
         HoldLow              => thold_C_CLK_negedge_posedge(27),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(28),
         TimingData           => Tmkr_C_CLK_posedge(28),
         TestSignal           => C_dly(28),
         TestSignalName       => "C(28)",
         TestDelay            => tisd_C_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(28),
         SetupLow             => tsetup_C_CLK_negedge_posedge(28),
         HoldHigh             => thold_C_CLK_posedge_posedge(28),
         HoldLow              => thold_C_CLK_negedge_posedge(28),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(29),
         TimingData           => Tmkr_C_CLK_posedge(29),
         TestSignal           => C_dly(29),
         TestSignalName       => "C(29)",
         TestDelay            => tisd_C_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(29),
         SetupLow             => tsetup_C_CLK_negedge_posedge(29),
         HoldHigh             => thold_C_CLK_posedge_posedge(29),
         HoldLow              => thold_C_CLK_negedge_posedge(29),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(30),
         TimingData           => Tmkr_C_CLK_posedge(30),
         TestSignal           => C_dly(30),
         TestSignalName       => "C(30)",
         TestDelay            => tisd_C_CLK(30),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(30),
         SetupLow             => tsetup_C_CLK_negedge_posedge(30),
         HoldHigh             => thold_C_CLK_posedge_posedge(30),
         HoldLow              => thold_C_CLK_negedge_posedge(30),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(31),
         TimingData           => Tmkr_C_CLK_posedge(31),
         TestSignal           => C_dly(31),
         TestSignalName       => "C(31)",
         TestDelay            => tisd_C_CLK(31),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(31),
         SetupLow             => tsetup_C_CLK_negedge_posedge(31),
         HoldHigh             => thold_C_CLK_posedge_posedge(31),
         HoldLow              => thold_C_CLK_negedge_posedge(31),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(32),
         TimingData           => Tmkr_C_CLK_posedge(32),
         TestSignal           => C_dly(32),
         TestSignalName       => "C(32)",
         TestDelay            => tisd_C_CLK(32),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(32),
         SetupLow             => tsetup_C_CLK_negedge_posedge(32),
         HoldHigh             => thold_C_CLK_posedge_posedge(32),
         HoldLow              => thold_C_CLK_negedge_posedge(32),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(33),
         TimingData           => Tmkr_C_CLK_posedge(33),
         TestSignal           => C_dly(33),
         TestSignalName       => "C(33)",
         TestDelay            => tisd_C_CLK(33),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(33),
         SetupLow             => tsetup_C_CLK_negedge_posedge(33),
         HoldHigh             => thold_C_CLK_posedge_posedge(33),
         HoldLow              => thold_C_CLK_negedge_posedge(33),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(34),
         TimingData           => Tmkr_C_CLK_posedge(34),
         TestSignal           => C_dly(34),
         TestSignalName       => "C(34)",
         TestDelay            => tisd_C_CLK(34),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(34),
         SetupLow             => tsetup_C_CLK_negedge_posedge(34),
         HoldHigh             => thold_C_CLK_posedge_posedge(34),
         HoldLow              => thold_C_CLK_negedge_posedge(34),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(35),
         TimingData           => Tmkr_C_CLK_posedge(35),
         TestSignal           => C_dly(35),
         TestSignalName       => "C(35)",
         TestDelay            => tisd_C_CLK(35),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(35),
         SetupLow             => tsetup_C_CLK_negedge_posedge(35),
         HoldHigh             => thold_C_CLK_posedge_posedge(35),
         HoldLow              => thold_C_CLK_negedge_posedge(35),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(36),
         TimingData           => Tmkr_C_CLK_posedge(36),
         TestSignal           => C_dly(36),
         TestSignalName       => "C(36)",
         TestDelay            => tisd_C_CLK(36),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(36),
         SetupLow             => tsetup_C_CLK_negedge_posedge(36),
         HoldHigh             => thold_C_CLK_posedge_posedge(36),
         HoldLow              => thold_C_CLK_negedge_posedge(36),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(37),
         TimingData           => Tmkr_C_CLK_posedge(37),
         TestSignal           => C_dly(37),
         TestSignalName       => "C(37)",
         TestDelay            => tisd_C_CLK(37),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(37),
         SetupLow             => tsetup_C_CLK_negedge_posedge(37),
         HoldHigh             => thold_C_CLK_posedge_posedge(37),
         HoldLow              => thold_C_CLK_negedge_posedge(37),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(38),
         TimingData           => Tmkr_C_CLK_posedge(38),
         TestSignal           => C_dly(38),
         TestSignalName       => "C(38)",
         TestDelay            => tisd_C_CLK(38),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(38),
         SetupLow             => tsetup_C_CLK_negedge_posedge(38),
         HoldHigh             => thold_C_CLK_posedge_posedge(38),
         HoldLow              => thold_C_CLK_negedge_posedge(38),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(39),
         TimingData           => Tmkr_C_CLK_posedge(39),
         TestSignal           => C_dly(39),
         TestSignalName       => "C(39)",
         TestDelay            => tisd_C_CLK(39),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(39),
         SetupLow             => tsetup_C_CLK_negedge_posedge(39),
         HoldHigh             => thold_C_CLK_posedge_posedge(39),
         HoldLow              => thold_C_CLK_negedge_posedge(39),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(40),
         TimingData           => Tmkr_C_CLK_posedge(40),
         TestSignal           => C_dly(40),
         TestSignalName       => "C(40)",
         TestDelay            => tisd_C_CLK(40),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(40),
         SetupLow             => tsetup_C_CLK_negedge_posedge(40),
         HoldHigh             => thold_C_CLK_posedge_posedge(40),
         HoldLow              => thold_C_CLK_negedge_posedge(40),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(41),
         TimingData           => Tmkr_C_CLK_posedge(41),
         TestSignal           => C_dly(41),
         TestSignalName       => "C(41)",
         TestDelay            => tisd_C_CLK(41),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(41),
         SetupLow             => tsetup_C_CLK_negedge_posedge(41),
         HoldHigh             => thold_C_CLK_posedge_posedge(41),
         HoldLow              => thold_C_CLK_negedge_posedge(41),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(42),
         TimingData           => Tmkr_C_CLK_posedge(42),
         TestSignal           => C_dly(42),
         TestSignalName       => "C(42)",
         TestDelay            => tisd_C_CLK(42),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(42),
         SetupLow             => tsetup_C_CLK_negedge_posedge(42),
         HoldHigh             => thold_C_CLK_posedge_posedge(42),
         HoldLow              => thold_C_CLK_negedge_posedge(42),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(43),
         TimingData           => Tmkr_C_CLK_posedge(43),
         TestSignal           => C_dly(43),
         TestSignalName       => "C(43)",
         TestDelay            => tisd_C_CLK(43),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(43),
         SetupLow             => tsetup_C_CLK_negedge_posedge(43),
         HoldHigh             => thold_C_CLK_posedge_posedge(43),
         HoldLow              => thold_C_CLK_negedge_posedge(43),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(44),
         TimingData           => Tmkr_C_CLK_posedge(44),
         TestSignal           => C_dly(44),
         TestSignalName       => "C(44)",
         TestDelay            => tisd_C_CLK(44),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(44),
         SetupLow             => tsetup_C_CLK_negedge_posedge(44),
         HoldHigh             => thold_C_CLK_posedge_posedge(44),
         HoldLow              => thold_C_CLK_negedge_posedge(44),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(45),
         TimingData           => Tmkr_C_CLK_posedge(45),
         TestSignal           => C_dly(45),
         TestSignalName       => "C(45)",
         TestDelay            => tisd_C_CLK(45),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(45),
         SetupLow             => tsetup_C_CLK_negedge_posedge(45),
         HoldHigh             => thold_C_CLK_posedge_posedge(45),
         HoldLow              => thold_C_CLK_negedge_posedge(45),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(46),
         TimingData           => Tmkr_C_CLK_posedge(46),
         TestSignal           => C_dly(46),
         TestSignalName       => "C(46)",
         TestDelay            => tisd_C_CLK(46),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(46),
         SetupLow             => tsetup_C_CLK_negedge_posedge(46),
         HoldHigh             => thold_C_CLK_posedge_posedge(46),
         HoldLow              => thold_C_CLK_negedge_posedge(46),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_C_CLK_posedge(47),
         TimingData           => Tmkr_C_CLK_posedge(47),
         TestSignal           => C_dly(47),
         TestSignalName       => "C(47)",
         TestDelay            => tisd_C_CLK(47),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_C_CLK_posedge_posedge(47),
         SetupLow             => tsetup_C_CLK_negedge_posedge(47),
         HoldHigh             => thold_C_CLK_posedge_posedge(47),
         HoldLow              => thold_C_CLK_negedge_posedge(47),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly) and (CEC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYIN_CLK_posedge,
         TimingData           => Tmkr_CARRYIN_CLK_posedge,
         TestSignal           => CARRYIN_dly,
         TestSignalName       => "CARRYIN",
         TestDelay            => tisd_CARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CARRYIN_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCARRYIN_dly) and (CECARRYIN_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal CARRYINSEL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYINSEL_CLK_posedge(0),
         TimingData           => Tmkr_CARRYINSEL_CLK_posedge(0),
         TestSignal           => CARRYINSEL_dly(0),
         TestSignalName       => "CARRYINSEL(0)",
         TestDelay            => tisd_CARRYINSEL_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYINSEL_CLK_posedge_posedge(0),
         SetupLow             => tsetup_CARRYINSEL_CLK_negedge_posedge(0),
         HoldHigh             => thold_CARRYINSEL_CLK_posedge_posedge(0),
         HoldLow              => thold_CARRYINSEL_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CEA_dly) and (CEB_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_CARRYINSEL_CLK_posedge(1),
         TimingData           => Tmkr_CARRYINSEL_CLK_posedge(1),
         TestSignal           => CARRYINSEL_dly(1),
         TestSignalName       => "CARRYINSEL(1)",
         TestDelay            => tisd_CARRYINSEL_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CARRYINSEL_CLK_posedge_posedge(1),
         SetupLow             => tsetup_CARRYINSEL_CLK_negedge_posedge(1),
         HoldHigh             => thold_CARRYINSEL_CLK_posedge_posedge(1),
         HoldLow              => thold_CARRYINSEL_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CEA_dly) and (CEB_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CEA =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEA_CLK_posedge,
         TimingData           => Tmkr_CEA_CLK_posedge,
         TestSignal           => CEA_dly,
         TestSignalName       => "CEA",
         TestDelay            => tisd_CEA_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEA_CLK_posedge_posedge,
         SetupLow             => tsetup_CEA_CLK_negedge_posedge,
         HoldHigh             => thold_CEA_CLK_posedge_posedge,
         HoldLow              => thold_CEA_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CEB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEB_CLK_posedge,
         TimingData           => Tmkr_CEB_CLK_posedge,
         TestSignal           => CEB_dly,
         TestSignalName       => "CEB",
         TestDelay            => tisd_CEB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEB_CLK_posedge_posedge,
         SetupLow             => tsetup_CEB_CLK_negedge_posedge,
         HoldHigh             => thold_CEB_CLK_posedge_posedge,
         HoldLow              => thold_CEB_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CEC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEC_CLK_posedge,
         TimingData           => Tmkr_CEC_CLK_posedge,
         TestSignal           => CEC_dly,
         TestSignalName       => "CEC",
         TestDelay            => tisd_CEC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEC_CLK_posedge_posedge,
         SetupLow             => tsetup_CEC_CLK_negedge_posedge,
         HoldHigh             => thold_CEC_CLK_posedge_posedge,
         HoldLow              => thold_CEC_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTC_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CECARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECARRYIN_CLK_posedge,
         TimingData           => Tmkr_CECARRYIN_CLK_posedge,
         TestSignal           => CECARRYIN_dly,
         TestSignalName       => "CECARRYIN",
         TestDelay            => tisd_CECARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_CECARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_CECARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_CECARRYIN_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCARRYIN_dly) and (CECARRYIN_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CECINSUB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECINSUB_CLK_posedge,
         TimingData           => Tmkr_CECINSUB_CLK_posedge,
         TestSignal           => CECINSUB_dly,
         TestSignalName       => "CECINSUB",
         TestDelay            => tisd_CECINSUB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECINSUB_CLK_posedge_posedge,
         SetupLow             => tsetup_CECINSUB_CLK_negedge_posedge,
         HoldHigh             => thold_CECINSUB_CLK_posedge_posedge,
         HoldLow              => thold_CECINSUB_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CECTRL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CECTRL_CLK_posedge,
         TimingData           => Tmkr_CECTRL_CLK_posedge,
         TestSignal           => CECTRL_dly,
         TestSignalName       => "CECTRL",
         TestDelay            => tisd_CECTRL_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CECTRL_CLK_posedge_posedge,
         SetupLow             => tsetup_CECTRL_CLK_negedge_posedge,
         HoldHigh             => thold_CECTRL_CLK_posedge_posedge,
         HoldLow              => thold_CECTRL_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CEM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEM_CLK_posedge,
         TimingData           => Tmkr_CEM_CLK_posedge,
         TestSignal           => CEM_dly,
         TestSignalName       => "CEM",
         TestDelay            => tisd_CEM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEM_CLK_posedge_posedge,
         SetupLow             => tsetup_CEM_CLK_negedge_posedge,
         HoldHigh             => thold_CEM_CLK_posedge_posedge,
         HoldLow              => thold_CEM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0') and (TO_X01(not RSTM_dly) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal CEP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_CEP_CLK_posedge,
         TimingData           => Tmkr_CEP_CLK_posedge,
         TestSignal           => CEP_dly,
         TestSignalName       => "CEP",
         TestDelay            => tisd_CEP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_CEP_CLK_posedge_posedge,
         SetupLow             => tsetup_CEP_CLK_negedge_posedge,
         HoldHigh             => thold_CEP_CLK_posedge_posedge,
         HoldLow              => thold_CEP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal OPMODE =====
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(0),
         TimingData           => Tmkr_OPMODE_CLK_posedge(0),
         TestSignal           => OPMODE_dly(0),
         TestSignalName       => "OPMODE(0)",
         TestDelay            => tisd_OPMODE_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(0),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(0),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(0),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(1),
         TimingData           => Tmkr_OPMODE_CLK_posedge(1),
         TestSignal           => OPMODE_dly(1),
         TestSignalName       => "OPMODE(1)",
         TestDelay            => tisd_OPMODE_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(1),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(1),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(1),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(2),
         TimingData           => Tmkr_OPMODE_CLK_posedge(2),
         TestSignal           => OPMODE_dly(2),
         TestSignalName       => "OPMODE(2)",
         TestDelay            => tisd_OPMODE_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(2),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(2),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(2),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(3),
         TimingData           => Tmkr_OPMODE_CLK_posedge(3),
         TestSignal           => OPMODE_dly(3),
         TestSignalName       => "OPMODE(3)",
         TestDelay            => tisd_OPMODE_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(3),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(3),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(3),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(4),
         TimingData           => Tmkr_OPMODE_CLK_posedge(4),
         TestSignal           => OPMODE_dly(4),
         TestSignalName       => "OPMODE(4)",
         TestDelay            => tisd_OPMODE_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(4),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(4),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(4),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(5),
         TimingData           => Tmkr_OPMODE_CLK_posedge(5),
         TestSignal           => OPMODE_dly(5),
         TestSignalName       => "OPMODE(5)",
         TestDelay            => tisd_OPMODE_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(5),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(5),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(5),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_OPMODE_CLK_posedge(6),
         TimingData           => Tmkr_OPMODE_CLK_posedge(6),
         TestSignal           => OPMODE_dly(6),
         TestSignalName       => "OPMODE(6)",
         TestDelay            => tisd_OPMODE_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_OPMODE_CLK_posedge_posedge(6),
         SetupLow             => tsetup_OPMODE_CLK_negedge_posedge(6),
         HoldHigh             => thold_OPMODE_CLK_posedge_posedge(6),
         HoldLow              => thold_OPMODE_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTCTRL_dly) and (CECTRL_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks for Bus signal PCIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(0),
         TimingData           => Tmkr_PCIN_CLK_posedge(0),
         TestSignal           => PCIN_dly(0),
         TestSignalName       => "PCIN(0)",
         TestDelay            => tisd_PCIN_CLK(0),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(0),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(0),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(0),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(0),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(1),
         TimingData           => Tmkr_PCIN_CLK_posedge(1),
         TestSignal           => PCIN_dly(1),
         TestSignalName       => "PCIN(1)",
         TestDelay            => tisd_PCIN_CLK(1),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(1),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(1),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(1),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(1),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(2),
         TimingData           => Tmkr_PCIN_CLK_posedge(2),
         TestSignal           => PCIN_dly(2),
         TestSignalName       => "PCIN(2)",
         TestDelay            => tisd_PCIN_CLK(2),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(2),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(2),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(2),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(2),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(3),
         TimingData           => Tmkr_PCIN_CLK_posedge(3),
         TestSignal           => PCIN_dly(3),
         TestSignalName       => "PCIN(3)",
         TestDelay            => tisd_PCIN_CLK(3),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(3),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(3),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(3),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(3),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(4),
         TimingData           => Tmkr_PCIN_CLK_posedge(4),
         TestSignal           => PCIN_dly(4),
         TestSignalName       => "PCIN(4)",
         TestDelay            => tisd_PCIN_CLK(4),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(4),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(4),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(4),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(4),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(5),
         TimingData           => Tmkr_PCIN_CLK_posedge(5),
         TestSignal           => PCIN_dly(5),
         TestSignalName       => "PCIN(5)",
         TestDelay            => tisd_PCIN_CLK(5),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(5),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(5),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(5),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(5),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(6),
         TimingData           => Tmkr_PCIN_CLK_posedge(6),
         TestSignal           => PCIN_dly(6),
         TestSignalName       => "PCIN(6)",
         TestDelay            => tisd_PCIN_CLK(6),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(6),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(6),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(6),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(6),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(7),
         TimingData           => Tmkr_PCIN_CLK_posedge(7),
         TestSignal           => PCIN_dly(7),
         TestSignalName       => "PCIN(7)",
         TestDelay            => tisd_PCIN_CLK(7),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(7),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(7),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(7),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(7),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(8),
         TimingData           => Tmkr_PCIN_CLK_posedge(8),
         TestSignal           => PCIN_dly(8),
         TestSignalName       => "PCIN(8)",
         TestDelay            => tisd_PCIN_CLK(8),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(8),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(8),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(8),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(8),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(9),
         TimingData           => Tmkr_PCIN_CLK_posedge(9),
         TestSignal           => PCIN_dly(9),
         TestSignalName       => "PCIN(9)",
         TestDelay            => tisd_PCIN_CLK(9),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(9),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(9),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(9),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(9),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(10),
         TimingData           => Tmkr_PCIN_CLK_posedge(10),
         TestSignal           => PCIN_dly(10),
         TestSignalName       => "PCIN(10)",
         TestDelay            => tisd_PCIN_CLK(10),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(10),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(10),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(10),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(10),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(11),
         TimingData           => Tmkr_PCIN_CLK_posedge(11),
         TestSignal           => PCIN_dly(11),
         TestSignalName       => "PCIN(11)",
         TestDelay            => tisd_PCIN_CLK(11),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(11),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(11),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(11),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(11),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(12),
         TimingData           => Tmkr_PCIN_CLK_posedge(12),
         TestSignal           => PCIN_dly(12),
         TestSignalName       => "PCIN(12)",
         TestDelay            => tisd_PCIN_CLK(12),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(12),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(12),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(12),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(12),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(13),
         TimingData           => Tmkr_PCIN_CLK_posedge(13),
         TestSignal           => PCIN_dly(13),
         TestSignalName       => "PCIN(13)",
         TestDelay            => tisd_PCIN_CLK(13),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(13),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(13),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(13),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(13),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(14),
         TimingData           => Tmkr_PCIN_CLK_posedge(14),
         TestSignal           => PCIN_dly(14),
         TestSignalName       => "PCIN(14)",
         TestDelay            => tisd_PCIN_CLK(14),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(14),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(14),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(14),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(14),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(15),
         TimingData           => Tmkr_PCIN_CLK_posedge(15),
         TestSignal           => PCIN_dly(15),
         TestSignalName       => "PCIN(15)",
         TestDelay            => tisd_PCIN_CLK(15),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(15),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(15),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(15),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(15),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(16),
         TimingData           => Tmkr_PCIN_CLK_posedge(16),
         TestSignal           => PCIN_dly(16),
         TestSignalName       => "PCIN(16)",
         TestDelay            => tisd_PCIN_CLK(16),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(16),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(16),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(16),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(16),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(17),
         TimingData           => Tmkr_PCIN_CLK_posedge(17),
         TestSignal           => PCIN_dly(17),
         TestSignalName       => "PCIN(17)",
         TestDelay            => tisd_PCIN_CLK(17),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(17),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(17),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(17),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(17),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(18),
         TimingData           => Tmkr_PCIN_CLK_posedge(18),
         TestSignal           => PCIN_dly(18),
         TestSignalName       => "PCIN(18)",
         TestDelay            => tisd_PCIN_CLK(18),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(18),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(18),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(18),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(18),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(19),
         TimingData           => Tmkr_PCIN_CLK_posedge(19),
         TestSignal           => PCIN_dly(19),
         TestSignalName       => "PCIN(19)",
         TestDelay            => tisd_PCIN_CLK(19),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(19),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(19),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(19),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(19),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(20),
         TimingData           => Tmkr_PCIN_CLK_posedge(20),
         TestSignal           => PCIN_dly(20),
         TestSignalName       => "PCIN(20)",
         TestDelay            => tisd_PCIN_CLK(20),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(20),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(20),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(20),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(20),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(21),
         TimingData           => Tmkr_PCIN_CLK_posedge(21),
         TestSignal           => PCIN_dly(21),
         TestSignalName       => "PCIN(21)",
         TestDelay            => tisd_PCIN_CLK(21),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(21),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(21),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(21),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(21),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(22),
         TimingData           => Tmkr_PCIN_CLK_posedge(22),
         TestSignal           => PCIN_dly(22),
         TestSignalName       => "PCIN(22)",
         TestDelay            => tisd_PCIN_CLK(22),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(22),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(22),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(22),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(22),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(23),
         TimingData           => Tmkr_PCIN_CLK_posedge(23),
         TestSignal           => PCIN_dly(23),
         TestSignalName       => "PCIN(23)",
         TestDelay            => tisd_PCIN_CLK(23),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(23),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(23),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(23),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(23),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(24),
         TimingData           => Tmkr_PCIN_CLK_posedge(24),
         TestSignal           => PCIN_dly(24),
         TestSignalName       => "PCIN(24)",
         TestDelay            => tisd_PCIN_CLK(24),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(24),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(24),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(24),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(24),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(25),
         TimingData           => Tmkr_PCIN_CLK_posedge(25),
         TestSignal           => PCIN_dly(25),
         TestSignalName       => "PCIN(25)",
         TestDelay            => tisd_PCIN_CLK(25),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(25),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(25),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(25),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(25),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(26),
         TimingData           => Tmkr_PCIN_CLK_posedge(26),
         TestSignal           => PCIN_dly(26),
         TestSignalName       => "PCIN(26)",
         TestDelay            => tisd_PCIN_CLK(26),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(26),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(26),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(26),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(26),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(27),
         TimingData           => Tmkr_PCIN_CLK_posedge(27),
         TestSignal           => PCIN_dly(27),
         TestSignalName       => "PCIN(27)",
         TestDelay            => tisd_PCIN_CLK(27),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(27),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(27),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(27),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(27),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(28),
         TimingData           => Tmkr_PCIN_CLK_posedge(28),
         TestSignal           => PCIN_dly(28),
         TestSignalName       => "PCIN(28)",
         TestDelay            => tisd_PCIN_CLK(28),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(28),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(28),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(28),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(28),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(29),
         TimingData           => Tmkr_PCIN_CLK_posedge(29),
         TestSignal           => PCIN_dly(29),
         TestSignalName       => "PCIN(29)",
         TestDelay            => tisd_PCIN_CLK(29),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(29),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(29),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(29),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(29),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(30),
         TimingData           => Tmkr_PCIN_CLK_posedge(30),
         TestSignal           => PCIN_dly(30),
         TestSignalName       => "PCIN(30)",
         TestDelay            => tisd_PCIN_CLK(30),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(30),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(30),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(30),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(30),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(31),
         TimingData           => Tmkr_PCIN_CLK_posedge(31),
         TestSignal           => PCIN_dly(31),
         TestSignalName       => "PCIN(31)",
         TestDelay            => tisd_PCIN_CLK(31),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(31),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(31),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(31),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(31),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(32),
         TimingData           => Tmkr_PCIN_CLK_posedge(32),
         TestSignal           => PCIN_dly(32),
         TestSignalName       => "PCIN(32)",
         TestDelay            => tisd_PCIN_CLK(32),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(32),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(32),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(32),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(32),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(33),
         TimingData           => Tmkr_PCIN_CLK_posedge(33),
         TestSignal           => PCIN_dly(33),
         TestSignalName       => "PCIN(33)",
         TestDelay            => tisd_PCIN_CLK(33),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(33),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(33),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(33),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(33),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(34),
         TimingData           => Tmkr_PCIN_CLK_posedge(34),
         TestSignal           => PCIN_dly(34),
         TestSignalName       => "PCIN(34)",
         TestDelay            => tisd_PCIN_CLK(34),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(34),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(34),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(34),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(34),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(35),
         TimingData           => Tmkr_PCIN_CLK_posedge(35),
         TestSignal           => PCIN_dly(35),
         TestSignalName       => "PCIN(35)",
         TestDelay            => tisd_PCIN_CLK(35),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(35),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(35),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(35),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(35),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(36),
         TimingData           => Tmkr_PCIN_CLK_posedge(36),
         TestSignal           => PCIN_dly(36),
         TestSignalName       => "PCIN(36)",
         TestDelay            => tisd_PCIN_CLK(36),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(36),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(36),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(36),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(36),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(37),
         TimingData           => Tmkr_PCIN_CLK_posedge(37),
         TestSignal           => PCIN_dly(37),
         TestSignalName       => "PCIN(37)",
         TestDelay            => tisd_PCIN_CLK(37),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(37),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(37),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(37),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(37),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(38),
         TimingData           => Tmkr_PCIN_CLK_posedge(38),
         TestSignal           => PCIN_dly(38),
         TestSignalName       => "PCIN(38)",
         TestDelay            => tisd_PCIN_CLK(38),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(38),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(38),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(38),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(38),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(39),
         TimingData           => Tmkr_PCIN_CLK_posedge(39),
         TestSignal           => PCIN_dly(39),
         TestSignalName       => "PCIN(39)",
         TestDelay            => tisd_PCIN_CLK(39),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(39),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(39),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(39),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(39),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(40),
         TimingData           => Tmkr_PCIN_CLK_posedge(40),
         TestSignal           => PCIN_dly(40),
         TestSignalName       => "PCIN(40)",
         TestDelay            => tisd_PCIN_CLK(40),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(40),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(40),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(40),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(40),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(41),
         TimingData           => Tmkr_PCIN_CLK_posedge(41),
         TestSignal           => PCIN_dly(41),
         TestSignalName       => "PCIN(41)",
         TestDelay            => tisd_PCIN_CLK(41),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(41),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(41),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(41),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(41),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(42),
         TimingData           => Tmkr_PCIN_CLK_posedge(42),
         TestSignal           => PCIN_dly(42),
         TestSignalName       => "PCIN(42)",
         TestDelay            => tisd_PCIN_CLK(42),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(42),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(42),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(42),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(42),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(43),
         TimingData           => Tmkr_PCIN_CLK_posedge(43),
         TestSignal           => PCIN_dly(43),
         TestSignalName       => "PCIN(43)",
         TestDelay            => tisd_PCIN_CLK(43),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(43),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(43),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(43),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(43),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(44),
         TimingData           => Tmkr_PCIN_CLK_posedge(44),
         TestSignal           => PCIN_dly(44),
         TestSignalName       => "PCIN(44)",
         TestDelay            => tisd_PCIN_CLK(44),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(44),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(44),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(44),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(44),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(45),
         TimingData           => Tmkr_PCIN_CLK_posedge(45),
         TestSignal           => PCIN_dly(45),
         TestSignalName       => "PCIN(45)",
         TestDelay            => tisd_PCIN_CLK(45),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(45),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(45),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(45),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(45),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(46),
         TimingData           => Tmkr_PCIN_CLK_posedge(46),
         TestSignal           => PCIN_dly(46),
         TestSignalName       => "PCIN(46)",
         TestDelay            => tisd_PCIN_CLK(46),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(46),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(46),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(46),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(46),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
       VitalSetupHoldCheck (
         Violation            => Tviol_PCIN_CLK_posedge(47),
         TimingData           => Tmkr_PCIN_CLK_posedge(47),
         TestSignal           => PCIN_dly(47),
         TestSignalName       => "PCIN(47)",
         TestDelay            => tisd_PCIN_CLK(47),
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_PCIN_CLK_posedge_posedge(47),
         SetupLow             => tsetup_PCIN_CLK_negedge_posedge(47),
         HoldHigh             => thold_PCIN_CLK_posedge_posedge(47),
         HoldLow              => thold_PCIN_CLK_negedge_posedge(47),
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTP_dly) and (CEP_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => True,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTA =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTA_CLK_posedge,
         TimingData           => Tmkr_RSTA_CLK_posedge,
         TestSignal           => RSTA_dly,
         TestSignalName       => "RSTA",
         TestDelay            => tisd_RSTA_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTA_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTA_CLK_negedge_posedge,
         HoldHigh             => thold_RSTA_CLK_posedge_posedge,
         HoldLow              => thold_RSTA_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTB =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTB_CLK_posedge,
         TimingData           => Tmkr_RSTB_CLK_posedge,
         TestSignal           => RSTB_dly,
         TestSignalName       => "RSTB",
         TestDelay            => tisd_RSTB_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTB_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTB_CLK_negedge_posedge,
         HoldHigh             => thold_RSTB_CLK_posedge_posedge,
         HoldLow              => thold_RSTB_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTC =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTC_CLK_posedge,
         TimingData           => Tmkr_RSTC_CLK_posedge,
         TestSignal           => RSTC_dly,
         TestSignalName       => "RSTC",
         TestDelay            => tisd_RSTC_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTC_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTC_CLK_negedge_posedge,
         HoldHigh             => thold_RSTC_CLK_posedge_posedge,
         HoldLow              => thold_RSTC_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTCARRYIN =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTCARRYIN_CLK_posedge,
         TimingData           => Tmkr_RSTCARRYIN_CLK_posedge,
         TestSignal           => RSTCARRYIN_dly,
         TestSignalName       => "RSTCARRYIN",
         TestDelay            => tisd_RSTCARRYIN_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTCARRYIN_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTCARRYIN_CLK_negedge_posedge,
         HoldHigh             => thold_RSTCARRYIN_CLK_posedge_posedge,
         HoldLow              => thold_RSTCARRYIN_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTCTRL =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTCTRL_CLK_posedge,
         TimingData           => Tmkr_RSTCTRL_CLK_posedge,
         TestSignal           => RSTCTRL_dly,
         TestSignalName       => "RSTCTRL",
         TestDelay            => tisd_RSTCTRL_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTCTRL_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTCTRL_CLK_negedge_posedge,
         HoldHigh             => thold_RSTCTRL_CLK_posedge_posedge,
         HoldLow              => thold_RSTCTRL_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTM =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTM_CLK_posedge,
         TimingData           => Tmkr_RSTM_CLK_posedge,
         TestSignal           => RSTM_dly,
         TestSignalName       => "RSTM",
         TestDelay            => tisd_RSTM_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTM_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTM_CLK_negedge_posedge,
         HoldHigh             => thold_RSTM_CLK_posedge_posedge,
         HoldLow              => thold_RSTM_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal RSTP =====
       VitalSetupHoldCheck (
         Violation            => Tviol_RSTP_CLK_posedge,
         TimingData           => Tmkr_RSTP_CLK_posedge,
         TestSignal           => RSTP_dly,
         TestSignalName       => "RSTP",
         TestDelay            => tisd_RSTP_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_RSTP_CLK_posedge_posedge,
         SetupLow             => tsetup_RSTP_CLK_negedge_posedge,
         HoldHigh             => thold_RSTP_CLK_posedge_posedge,
         HoldLow              => thold_RSTP_CLK_negedge_posedge,
         CheckEnabled         => (TO_X01(GSR_dly) = '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--=====  Vital SetupHold Checks signal SUBTRACT =====
       VitalSetupHoldCheck (
         Violation            => Tviol_SUBTRACT_CLK_posedge,
         TimingData           => Tmkr_SUBTRACT_CLK_posedge,
         TestSignal           => SUBTRACT_dly,
         TestSignalName       => "SUBTRACT",
         TestDelay            => tisd_SUBTRACT_CLK,
         RefSignal            => CLK_dly,
         RefSignalName        => "CLK",
         RefDelay             => ticd_CLK,
         SetupHigh            => tsetup_SUBTRACT_CLK_posedge_posedge,
         SetupLow             => tsetup_SUBTRACT_CLK_negedge_posedge,
         HoldHigh             => thold_SUBTRACT_CLK_posedge_posedge,
         HoldLow              => thold_SUBTRACT_CLK_negedge_posedge,
         CheckEnabled         => ((TO_X01(GSR_dly) = '0') and (TO_X01(not RSTA_dly) and (not RSTB_dly) and (not RSTCTRL_dly) and (CEA_dly) and (CEB_dly)) /= '0'),
         RefTransition        => 'R',
         HeaderMsg            => InstancePath & "/X_DSP48",
         Xon                  => Xon,
         MsgOn                => true,
         MsgSeverity          => Error);
--==========  FP
      VitalPeriodPulseCheck (
        Violation            => Pviol_CLK,
        PeriodData           => PInfo_CLK,
        TestSignal           => CLK_dly,
        TestSignalName       => "CLK",
        TestDelay            => 0 ps,
        Period               => tperiod_CLK_posedge,
        PulseWidthHigh       => tpw_CLK_posedge,
        PulseWidthLow        => tpw_CLK_negedge,
        CheckEnabled         => (TO_X01(GSR_dly) = '0'),
        HeaderMsg            => "/X_DSP48",
        Xon                  => Xon,
        MsgOn                => MsgOn,
        MsgSeverity          => Error
      );

     end if;
-- End of (TimingChecksOn)

--  Output-to-Clock path delay
       VitalPathDelay01 (
         OutSignal	=> P(47),
         GlitchData	=> P_GlitchData(47),
         OutSignalName	=> "P(47)",
         OutTemp	=> P_zd(47),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 47)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 47)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 47)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 47)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 47)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 47)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 47)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 47)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 47)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 47)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 47)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 47)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 47)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 47)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 47)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 47)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 47)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 47)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 47)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 47)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 47)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 47)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 47)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 47)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 47)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 47)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 47)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 47)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 47)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 47)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 47)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 47)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 47)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 47)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 47)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 47)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 47)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 47)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 47)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 47)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 47)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 47)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 47)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 47)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 47)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 47)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 47)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 47)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 47)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 47)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 47)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 47)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 47)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 47)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 47)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 47)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 47)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 47)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 47)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 47)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 47)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 47)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 47)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 47)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 47)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 47)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 47)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 47)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 47)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 47)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 47)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 47)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 47)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 47)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 47)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 47)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 47)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 47)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 47)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 47)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 47)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 47)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 47)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 47)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 47)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 47)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 47)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 47)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 47)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 47)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 47)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 47)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 47)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 47)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 47)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 47)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 47)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 47)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 47)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 47)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 47)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 47)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(47), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 47)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 47)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 47)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 47)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 47)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 47)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 47)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 47)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 47)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 47)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 47)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 47)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 47)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 47)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 47)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 47)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 47)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 47)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 47)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 47)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 47)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 47)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 47)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 47)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 47)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 47)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 47)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 47)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 47)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 47)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 47)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 47)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 47)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 47)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 47)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 47)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 47)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 47)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 47)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 47)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 47)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 47)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 47)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 47)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 47)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 47)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 47)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 47)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 47)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 47)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 47)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 47)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 47)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 47)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 47)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(47), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(47), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(46),
         GlitchData	=> P_GlitchData(46),
         OutSignalName	=> "P(46)",
         OutTemp	=> P_zd(46),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 46)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 46)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 46)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 46)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 46)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 46)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 46)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 46)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 46)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 46)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 46)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 46)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 46)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 46)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 46)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 46)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 46)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 46)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 46)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 46)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 46)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 46)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 46)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 46)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 46)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 46)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 46)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 46)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 46)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 46)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 46)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 46)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 46)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 46)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 46)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 46)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 46)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 46)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 46)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 46)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 46)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 46)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 46)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 46)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 46)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 46)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 46)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 46)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 46)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 46)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 46)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 46)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 46)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 46)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 46)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 46)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 46)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 46)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 46)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 46)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 46)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 46)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 46)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 46)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 46)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 46)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 46)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 46)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 46)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 46)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 46)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 46)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 46)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 46)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 46)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 46)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 46)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 46)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 46)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 46)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 46)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 46)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 46)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 46)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 46)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 46)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 46)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 46)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 46)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 46)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 46)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 46)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 46)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 46)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 46)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 46)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 46)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 46)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 46)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 46)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 46)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 46)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(46), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 46)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 46)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 46)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 46)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 46)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 46)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 46)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 46)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 46)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 46)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 46)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 46)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 46)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 46)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 46)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 46)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 46)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 46)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 46)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 46)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 46)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 46)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 46)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 46)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 46)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 46)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 46)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 46)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 46)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 46)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 46)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 46)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 46)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 46)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 46)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 46)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 46)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 46)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 46)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 46)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 46)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 46)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 46)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 46)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 46)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 46)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 46)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 46)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 46)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 46)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 46)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 46)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 46)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 46)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 46)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(46), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(46), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(45),
         GlitchData	=> P_GlitchData(45),
         OutSignalName	=> "P(45)",
         OutTemp	=> P_zd(45),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 45)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 45)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 45)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 45)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 45)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 45)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 45)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 45)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 45)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 45)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 45)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 45)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 45)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 45)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 45)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 45)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 45)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 45)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 45)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 45)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 45)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 45)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 45)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 45)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 45)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 45)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 45)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 45)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 45)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 45)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 45)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 45)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 45)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 45)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 45)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 45)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 45)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 45)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 45)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 45)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 45)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 45)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 45)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 45)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 45)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 45)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 45)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 45)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 45)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 45)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 45)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 45)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 45)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 45)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 45)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 45)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 45)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 45)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 45)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 45)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 45)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 45)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 45)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 45)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 45)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 45)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 45)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 45)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 45)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 45)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 45)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 45)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 45)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 45)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 45)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 45)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 45)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 45)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 45)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 45)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 45)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 45)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 45)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 45)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 45)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 45)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 45)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 45)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 45)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 45)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 45)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 45)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 45)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 45)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 45)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 45)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 45)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 45)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 45)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 45)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 45)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 45)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(45), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 45)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 45)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 45)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 45)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 45)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 45)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 45)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 45)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 45)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 45)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 45)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 45)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 45)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 45)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 45)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 45)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 45)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 45)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 45)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 45)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 45)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 45)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 45)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 45)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 45)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 45)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 45)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 45)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 45)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 45)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 45)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 45)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 45)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 45)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 45)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 45)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 45)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 45)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 45)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 45)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 45)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 45)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 45)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 45)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 45)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 45)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 45)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 45)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 45)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 45)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 45)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 45)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 45)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 45)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 45)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(45), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(45), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(44),
         GlitchData	=> P_GlitchData(44),
         OutSignalName	=> "P(44)",
         OutTemp	=> P_zd(44),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 44)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 44)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 44)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 44)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 44)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 44)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 44)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 44)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 44)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 44)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 44)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 44)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 44)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 44)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 44)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 44)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 44)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 44)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 44)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 44)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 44)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 44)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 44)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 44)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 44)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 44)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 44)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 44)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 44)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 44)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 44)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 44)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 44)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 44)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 44)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 44)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 44)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 44)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 44)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 44)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 44)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 44)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 44)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 44)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 44)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 44)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 44)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 44)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 44)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 44)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 44)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 44)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 44)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 44)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 44)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 44)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 44)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 44)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 44)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 44)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 44)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 44)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 44)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 44)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 44)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 44)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 44)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 44)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 44)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 44)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 44)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 44)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 44)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 44)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 44)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 44)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 44)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 44)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 44)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 44)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 44)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 44)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 44)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 44)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 44)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 44)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 44)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 44)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 44)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 44)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 44)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 44)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 44)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 44)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 44)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 44)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 44)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 44)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 44)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 44)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 44)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 44)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(44), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 44)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 44)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 44)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 44)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 44)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 44)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 44)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 44)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 44)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 44)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 44)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 44)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 44)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 44)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 44)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 44)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 44)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 44)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 44)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 44)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 44)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 44)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 44)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 44)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 44)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 44)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 44)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 44)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 44)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 44)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 44)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 44)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 44)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 44)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 44)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 44)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 44)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 44)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 44)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 44)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 44)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 44)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 44)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 44)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 44)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 44)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 44)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 44)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 44)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 44)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 44)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 44)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 44)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 44)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 44)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(44), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(44), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(43),
         GlitchData	=> P_GlitchData(43),
         OutSignalName	=> "P(43)",
         OutTemp	=> P_zd(43),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 43)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 43)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 43)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 43)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 43)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 43)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 43)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 43)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 43)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 43)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 43)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 43)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 43)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 43)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 43)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 43)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 43)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 43)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 43)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 43)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 43)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 43)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 43)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 43)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 43)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 43)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 43)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 43)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 43)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 43)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 43)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 43)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 43)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 43)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 43)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 43)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 43)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 43)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 43)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 43)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 43)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 43)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 43)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 43)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 43)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 43)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 43)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 43)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 43)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 43)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 43)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 43)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 43)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 43)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 43)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 43)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 43)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 43)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 43)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 43)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 43)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 43)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 43)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 43)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 43)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 43)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 43)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 43)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 43)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 43)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 43)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 43)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 43)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 43)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 43)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 43)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 43)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 43)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 43)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 43)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 43)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 43)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 43)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 43)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 43)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 43)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 43)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 43)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 43)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 43)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 43)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 43)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 43)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 43)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 43)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 43)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 43)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 43)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 43)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 43)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 43)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 43)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(43), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 43)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 43)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 43)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 43)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 43)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 43)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 43)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 43)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 43)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 43)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 43)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 43)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 43)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 43)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 43)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 43)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 43)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 43)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 43)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 43)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 43)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 43)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 43)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 43)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 43)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 43)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 43)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 43)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 43)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 43)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 43)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 43)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 43)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 43)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 43)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 43)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 43)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 43)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 43)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 43)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 43)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 43)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 43)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 43)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 43)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 43)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 43)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 43)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 43)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 43)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 43)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 43)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 43)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 43)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 43)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(43), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(43), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(42),
         GlitchData	=> P_GlitchData(42),
         OutSignalName	=> "P(42)",
         OutTemp	=> P_zd(42),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 42)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 42)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 42)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 42)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 42)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 42)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 42)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 42)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 42)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 42)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 42)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 42)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 42)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 42)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 42)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 42)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 42)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 42)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 42)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 42)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 42)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 42)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 42)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 42)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 42)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 42)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 42)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 42)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 42)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 42)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 42)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 42)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 42)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 42)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 42)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 42)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 42)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 42)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 42)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 42)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 42)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 42)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 42)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 42)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 42)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 42)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 42)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 42)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 42)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 42)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 42)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 42)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 42)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 42)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 42)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 42)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 42)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 42)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 42)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 42)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 42)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 42)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 42)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 42)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 42)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 42)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 42)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 42)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 42)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 42)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 42)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 42)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 42)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 42)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 42)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 42)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 42)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 42)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 42)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 42)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 42)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 42)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 42)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 42)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 42)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 42)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 42)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 42)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 42)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 42)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 42)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 42)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 42)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 42)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 42)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 42)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 42)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 42)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 42)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 42)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 42)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 42)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(42), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 42)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 42)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 42)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 42)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 42)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 42)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 42)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 42)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 42)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 42)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 42)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 42)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 42)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 42)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 42)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 42)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 42)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 42)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 42)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 42)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 42)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 42)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 42)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 42)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 42)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 42)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 42)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 42)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 42)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 42)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 42)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 42)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 42)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 42)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 42)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 42)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 42)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 42)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 42)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 42)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 42)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 42)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 42)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 42)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 42)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 42)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 42)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 42)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 42)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 42)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 42)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 42)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 42)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 42)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 42)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(42), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(42), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(41),
         GlitchData	=> P_GlitchData(41),
         OutSignalName	=> "P(41)",
         OutTemp	=> P_zd(41),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 41)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 41)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 41)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 41)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 41)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 41)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 41)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 41)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 41)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 41)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 41)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 41)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 41)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 41)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 41)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 41)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 41)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 41)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 41)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 41)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 41)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 41)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 41)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 41)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 41)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 41)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 41)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 41)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 41)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 41)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 41)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 41)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 41)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 41)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 41)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 41)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 41)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 41)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 41)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 41)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 41)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 41)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 41)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 41)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 41)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 41)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 41)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 41)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 41)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 41)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 41)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 41)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 41)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 41)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 41)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 41)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 41)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 41)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 41)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 41)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 41)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 41)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 41)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 41)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 41)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 41)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 41)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 41)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 41)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 41)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 41)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 41)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 41)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 41)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 41)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 41)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 41)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 41)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 41)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 41)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 41)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 41)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 41)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 41)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 41)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 41)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 41)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 41)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 41)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 41)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 41)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 41)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 41)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 41)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 41)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 41)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 41)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 41)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 41)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 41)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 41)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 41)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(41), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 41)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 41)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 41)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 41)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 41)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 41)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 41)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 41)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 41)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 41)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 41)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 41)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 41)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 41)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 41)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 41)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 41)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 41)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 41)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 41)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 41)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 41)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 41)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 41)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 41)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 41)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 41)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 41)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 41)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 41)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 41)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 41)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 41)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 41)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 41)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 41)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 41)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 41)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 41)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 41)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 41)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 41)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 41)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 41)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 41)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 41)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 41)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 41)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 41)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 41)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 41)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 41)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 41)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 41)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 41)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(41), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(41), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(40),
         GlitchData	=> P_GlitchData(40),
         OutSignalName	=> "P(40)",
         OutTemp	=> P_zd(40),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 40)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 40)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 40)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 40)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 40)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 40)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 40)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 40)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 40)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 40)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 40)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 40)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 40)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 40)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 40)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 40)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 40)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 40)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 40)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 40)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 40)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 40)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 40)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 40)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 40)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 40)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 40)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 40)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 40)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 40)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 40)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 40)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 40)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 40)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 40)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 40)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 40)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 40)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 40)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 40)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 40)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 40)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 40)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 40)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 40)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 40)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 40)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 40)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 40)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 40)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 40)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 40)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 40)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 40)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 40)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 40)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 40)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 40)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 40)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 40)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 40)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 40)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 40)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 40)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 40)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 40)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 40)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 40)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 40)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 40)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 40)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 40)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 40)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 40)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 40)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 40)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 40)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 40)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 40)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 40)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 40)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 40)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 40)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 40)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 40)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 40)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 40)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 40)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 40)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 40)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 40)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 40)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 40)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 40)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 40)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 40)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 40)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 40)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 40)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 40)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 40)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 40)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(40), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 40)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 40)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 40)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 40)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 40)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 40)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 40)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 40)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 40)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 40)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 40)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 40)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 40)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 40)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 40)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 40)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 40)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 40)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 40)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 40)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 40)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 40)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 40)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 40)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 40)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 40)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 40)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 40)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 40)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 40)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 40)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 40)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 40)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 40)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 40)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 40)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 40)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 40)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 40)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 40)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 40)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 40)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 40)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 40)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 40)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 40)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 40)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 40)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 40)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 40)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 40)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 40)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 40)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 40)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 40)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(40), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(40), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(39),
         GlitchData	=> P_GlitchData(39),
         OutSignalName	=> "P(39)",
         OutTemp	=> P_zd(39),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 39)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 39)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 39)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 39)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 39)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 39)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 39)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 39)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 39)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 39)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 39)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 39)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 39)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 39)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 39)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 39)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 39)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 39)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 39)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 39)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 39)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 39)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 39)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 39)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 39)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 39)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 39)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 39)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 39)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 39)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 39)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 39)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 39)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 39)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 39)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 39)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 39)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 39)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 39)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 39)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 39)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 39)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 39)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 39)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 39)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 39)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 39)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 39)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 39)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 39)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 39)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 39)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 39)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 39)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 39)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 39)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 39)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 39)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 39)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 39)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 39)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 39)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 39)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 39)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 39)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 39)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 39)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 39)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 39)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 39)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 39)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 39)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 39)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 39)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 39)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 39)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 39)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 39)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 39)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 39)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 39)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 39)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 39)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 39)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 39)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 39)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 39)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 39)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 39)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 39)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 39)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 39)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 39)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 39)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 39)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 39)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 39)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 39)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 39)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 39)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 39)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 39)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(39), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 39)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 39)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 39)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 39)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 39)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 39)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 39)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 39)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 39)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 39)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 39)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 39)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 39)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 39)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 39)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 39)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 39)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 39)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 39)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 39)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 39)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 39)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 39)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 39)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 39)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 39)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 39)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 39)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 39)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 39)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 39)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 39)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 39)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 39)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 39)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 39)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 39)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 39)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 39)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 39)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 39)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 39)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 39)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 39)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 39)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 39)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 39)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 39)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 39)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 39)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 39)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 39)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 39)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 39)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 39)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(39), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(39), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(38),
         GlitchData	=> P_GlitchData(38),
         OutSignalName	=> "P(38)",
         OutTemp	=> P_zd(38),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 38)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 38)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 38)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 38)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 38)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 38)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 38)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 38)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 38)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 38)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 38)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 38)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 38)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 38)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 38)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 38)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 38)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 38)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 38)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 38)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 38)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 38)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 38)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 38)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 38)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 38)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 38)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 38)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 38)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 38)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 38)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 38)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 38)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 38)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 38)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 38)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 38)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 38)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 38)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 38)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 38)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 38)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 38)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 38)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 38)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 38)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 38)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 38)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 38)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 38)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 38)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 38)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 38)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 38)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 38)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 38)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 38)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 38)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 38)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 38)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 38)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 38)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 38)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 38)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 38)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 38)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 38)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 38)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 38)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 38)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 38)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 38)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 38)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 38)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 38)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 38)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 38)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 38)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 38)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 38)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 38)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 38)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 38)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 38)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 38)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 38)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 38)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 38)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 38)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 38)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 38)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 38)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 38)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 38)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 38)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 38)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 38)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 38)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 38)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 38)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 38)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 38)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(38), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 38)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 38)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 38)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 38)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 38)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 38)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 38)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 38)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 38)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 38)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 38)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 38)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 38)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 38)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 38)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 38)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 38)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 38)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 38)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 38)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 38)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 38)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 38)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 38)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 38)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 38)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 38)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 38)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 38)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 38)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 38)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 38)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 38)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 38)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 38)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 38)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 38)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 38)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 38)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 38)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 38)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 38)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 38)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 38)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 38)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 38)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 38)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 38)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 38)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 38)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 38)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 38)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 38)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 38)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 38)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(38), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(38), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(37),
         GlitchData	=> P_GlitchData(37),
         OutSignalName	=> "P(37)",
         OutTemp	=> P_zd(37),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 37)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 37)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 37)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 37)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 37)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 37)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 37)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 37)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 37)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 37)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 37)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 37)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 37)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 37)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 37)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 37)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 37)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 37)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 37)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 37)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 37)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 37)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 37)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 37)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 37)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 37)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 37)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 37)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 37)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 37)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 37)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 37)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 37)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 37)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 37)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 37)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 37)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 37)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 37)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 37)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 37)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 37)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 37)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 37)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 37)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 37)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 37)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 37)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 37)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 37)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 37)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 37)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 37)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 37)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 37)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 37)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 37)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 37)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 37)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 37)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 37)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 37)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 37)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 37)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 37)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 37)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 37)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 37)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 37)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 37)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 37)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 37)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 37)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 37)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 37)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 37)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 37)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 37)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 37)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 37)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 37)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 37)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 37)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 37)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 37)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 37)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 37)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 37)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 37)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 37)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 37)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 37)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 37)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 37)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 37)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 37)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 37)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 37)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 37)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 37)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 37)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 37)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(37), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 37)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 37)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 37)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 37)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 37)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 37)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 37)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 37)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 37)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 37)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 37)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 37)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 37)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 37)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 37)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 37)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 37)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 37)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 37)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 37)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 37)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 37)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 37)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 37)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 37)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 37)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 37)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 37)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 37)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 37)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 37)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 37)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 37)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 37)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 37)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 37)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 37)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 37)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 37)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 37)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 37)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 37)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 37)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 37)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 37)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 37)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 37)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 37)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 37)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 37)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 37)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 37)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 37)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 37)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 37)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(37), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(37), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(36),
         GlitchData	=> P_GlitchData(36),
         OutSignalName	=> "P(36)",
         OutTemp	=> P_zd(36),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 36)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 36)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 36)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 36)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 36)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 36)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 36)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 36)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 36)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 36)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 36)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 36)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 36)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 36)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 36)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 36)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 36)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 36)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 36)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 36)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 36)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 36)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 36)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 36)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 36)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 36)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 36)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 36)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 36)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 36)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 36)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 36)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 36)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 36)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 36)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 36)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 36)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 36)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 36)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 36)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 36)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 36)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 36)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 36)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 36)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 36)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 36)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 36)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 36)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 36)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 36)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 36)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 36)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 36)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 36)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 36)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 36)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 36)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 36)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 36)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 36)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 36)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 36)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 36)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 36)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 36)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 36)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 36)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 36)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 36)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 36)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 36)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 36)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 36)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 36)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 36)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 36)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 36)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 36)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 36)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 36)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 36)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 36)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 36)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 36)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 36)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 36)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 36)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 36)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 36)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 36)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 36)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 36)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 36)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 36)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 36)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 36)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 36)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 36)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 36)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 36)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 36)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(36), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 36)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 36)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 36)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 36)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 36)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 36)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 36)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 36)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 36)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 36)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 36)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 36)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 36)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 36)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 36)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 36)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 36)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 36)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 36)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 36)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 36)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 36)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 36)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 36)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 36)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 36)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 36)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 36)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 36)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 36)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 36)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 36)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 36)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 36)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 36)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 36)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 36)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 36)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 36)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 36)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 36)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 36)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 36)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 36)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 36)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 36)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 36)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 36)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 36)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 36)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 36)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 36)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 36)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 36)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 36)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(36), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(36), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(35),
         GlitchData	=> P_GlitchData(35),
         OutSignalName	=> "P(35)",
         OutTemp	=> P_zd(35),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 35)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 35)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 35)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 35)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 35)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 35)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 35)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 35)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 35)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 35)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 35)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 35)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 35)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 35)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 35)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 35)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 35)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 35)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 35)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 35)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 35)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 35)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 35)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 35)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 35)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 35)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 35)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 35)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 35)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 35)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 35)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 35)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 35)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 35)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 35)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 35)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 35)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 35)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 35)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 35)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 35)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 35)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 35)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 35)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 35)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 35)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 35)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 35)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 35)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 35)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 35)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 35)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 35)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 35)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 35)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 35)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 35)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 35)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 35)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 35)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 35)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 35)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 35)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 35)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 35)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 35)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 35)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 35)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 35)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 35)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 35)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 35)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 35)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 35)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 35)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 35)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 35)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 35)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 35)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 35)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 35)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 35)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 35)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 35)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 35)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 35)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 35)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 35)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 35)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 35)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 35)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 35)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 35)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 35)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 35)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 35)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 35)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 35)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 35)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 35)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 35)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 35)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(35), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 35)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 35)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 35)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 35)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 35)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 35)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 35)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 35)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 35)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 35)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 35)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 35)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 35)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 35)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 35)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 35)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 35)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 35)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 35)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 35)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 35)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 35)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 35)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 35)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 35)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 35)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 35)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 35)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 35)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 35)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 35)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 35)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 35)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 35)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 35)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 35)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 35)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 35)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 35)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 35)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 35)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 35)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 35)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 35)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 35)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 35)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 35)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 35)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 35)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 35)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 35)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 35)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 35)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 35)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 35)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(35), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(35), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(34),
         GlitchData	=> P_GlitchData(34),
         OutSignalName	=> "P(34)",
         OutTemp	=> P_zd(34),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 34)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 34)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 34)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 34)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 34)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 34)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 34)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 34)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 34)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 34)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 34)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 34)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 34)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 34)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 34)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 34)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 34)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 34)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 34)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 34)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 34)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 34)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 34)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 34)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 34)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 34)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 34)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 34)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 34)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 34)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 34)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 34)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 34)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 34)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 34)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 34)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 34)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 34)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 34)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 34)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 34)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 34)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 34)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 34)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 34)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 34)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 34)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 34)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 34)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 34)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 34)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 34)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 34)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 34)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 34)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 34)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 34)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 34)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 34)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 34)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 34)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 34)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 34)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 34)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 34)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 34)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 34)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 34)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 34)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 34)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 34)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 34)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 34)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 34)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 34)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 34)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 34)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 34)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 34)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 34)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 34)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 34)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 34)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 34)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 34)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 34)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 34)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 34)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 34)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 34)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 34)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 34)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 34)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 34)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 34)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 34)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 34)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 34)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 34)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 34)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 34)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 34)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(34), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 34)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 34)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 34)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 34)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 34)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 34)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 34)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 34)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 34)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 34)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 34)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 34)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 34)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 34)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 34)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 34)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 34)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 34)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 34)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 34)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 34)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 34)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 34)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 34)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 34)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 34)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 34)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 34)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 34)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 34)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 34)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 34)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 34)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 34)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 34)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 34)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 34)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 34)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 34)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 34)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 34)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 34)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 34)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 34)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 34)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 34)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 34)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 34)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 34)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 34)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 34)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 34)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 34)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 34)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 34)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(34), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(34), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(33),
         GlitchData	=> P_GlitchData(33),
         OutSignalName	=> "P(33)",
         OutTemp	=> P_zd(33),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 33)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 33)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 33)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 33)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 33)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 33)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 33)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 33)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 33)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 33)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 33)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 33)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 33)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 33)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 33)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 33)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 33)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 33)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 33)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 33)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 33)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 33)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 33)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 33)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 33)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 33)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 33)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 33)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 33)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 33)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 33)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 33)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 33)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 33)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 33)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 33)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 33)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 33)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 33)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 33)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 33)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 33)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 33)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 33)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 33)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 33)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 33)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 33)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 33)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 33)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 33)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 33)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 33)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 33)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 33)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 33)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 33)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 33)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 33)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 33)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 33)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 33)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 33)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 33)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 33)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 33)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 33)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 33)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 33)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 33)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 33)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 33)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 33)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 33)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 33)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 33)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 33)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 33)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 33)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 33)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 33)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 33)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 33)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 33)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 33)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 33)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 33)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 33)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 33)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 33)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 33)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 33)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 33)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 33)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 33)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 33)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 33)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 33)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 33)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 33)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 33)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 33)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(33), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 33)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 33)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 33)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 33)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 33)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 33)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 33)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 33)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 33)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 33)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 33)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 33)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 33)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 33)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 33)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 33)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 33)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 33)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 33)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 33)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 33)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 33)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 33)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 33)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 33)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 33)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 33)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 33)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 33)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 33)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 33)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 33)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 33)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 33)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 33)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 33)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 33)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 33)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 33)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 33)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 33)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 33)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 33)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 33)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 33)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 33)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 33)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 33)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 33)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 33)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 33)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 33)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 33)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 33)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 33)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(33), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(33), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(32),
         GlitchData	=> P_GlitchData(32),
         OutSignalName	=> "P(32)",
         OutTemp	=> P_zd(32),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 32)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 32)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 32)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 32)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 32)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 32)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 32)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 32)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 32)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 32)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 32)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 32)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 32)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 32)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 32)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 32)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 32)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 32)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 32)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 32)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 32)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 32)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 32)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 32)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 32)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 32)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 32)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 32)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 32)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 32)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 32)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 32)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 32)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 32)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 32)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 32)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 32)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 32)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 32)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 32)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 32)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 32)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 32)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 32)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 32)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 32)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 32)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 32)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 32)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 32)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 32)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 32)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 32)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 32)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 32)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 32)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 32)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 32)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 32)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 32)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 32)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 32)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 32)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 32)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 32)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 32)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 32)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 32)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 32)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 32)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 32)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 32)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 32)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 32)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 32)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 32)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 32)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 32)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 32)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 32)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 32)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 32)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 32)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 32)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 32)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 32)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 32)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 32)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 32)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 32)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 32)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 32)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 32)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 32)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 32)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 32)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 32)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 32)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 32)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 32)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 32)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 32)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(32), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 32)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 32)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 32)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 32)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 32)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 32)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 32)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 32)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 32)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 32)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 32)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 32)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 32)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 32)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 32)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 32)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 32)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 32)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 32)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 32)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 32)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 32)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 32)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 32)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 32)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 32)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 32)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 32)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 32)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 32)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 32)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 32)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 32)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 32)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 32)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 32)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 32)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 32)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 32)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 32)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 32)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 32)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 32)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 32)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 32)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 32)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 32)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 32)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 32)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 32)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 32)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 32)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 32)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 32)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 32)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(32), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(32), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(31),
         GlitchData	=> P_GlitchData(31),
         OutSignalName	=> "P(31)",
         OutTemp	=> P_zd(31),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 31)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 31)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 31)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 31)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 31)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 31)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 31)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 31)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 31)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 31)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 31)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 31)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 31)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 31)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 31)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 31)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 31)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 31)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 31)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 31)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 31)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 31)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 31)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 31)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 31)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 31)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 31)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 31)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 31)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 31)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 31)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 31)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 31)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 31)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 31)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 31)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 31)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 31)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 31)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 31)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 31)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 31)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 31)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 31)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 31)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 31)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 31)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 31)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 31)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 31)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 31)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 31)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 31)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 31)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 31)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 31)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 31)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 31)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 31)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 31)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 31)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 31)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 31)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 31)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 31)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 31)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 31)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 31)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 31)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 31)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 31)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 31)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 31)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 31)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 31)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 31)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 31)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 31)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 31)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 31)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 31)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 31)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 31)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 31)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 31)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 31)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 31)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 31)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 31)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 31)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 31)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 31)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 31)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 31)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 31)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 31)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 31)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 31)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 31)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 31)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 31)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 31)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(31), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 31)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 31)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 31)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 31)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 31)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 31)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 31)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 31)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 31)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 31)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 31)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 31)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 31)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 31)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 31)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 31)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 31)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 31)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 31)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 31)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 31)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 31)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 31)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 31)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 31)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 31)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 31)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 31)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 31)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 31)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 31)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 31)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 31)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 31)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 31)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 31)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 31)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 31)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 31)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 31)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 31)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 31)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 31)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 31)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 31)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 31)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 31)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 31)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 31)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 31)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 31)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 31)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 31)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 31)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 31)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(31), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(31), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(30),
         GlitchData	=> P_GlitchData(30),
         OutSignalName	=> "P(30)",
         OutTemp	=> P_zd(30),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 30)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 30)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 30)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 30)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 30)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 30)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 30)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 30)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 30)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 30)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 30)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 30)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 30)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 30)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 30)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 30)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 30)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 30)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 30)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 30)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 30)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 30)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 30)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 30)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 30)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 30)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 30)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 30)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 30)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 30)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 30)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 30)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 30)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 30)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 30)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 30)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 30)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 30)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 30)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 30)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 30)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 30)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 30)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 30)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 30)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 30)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 30)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 30)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 30)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 30)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 30)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 30)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 30)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 30)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 30)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 30)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 30)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 30)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 30)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 30)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 30)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 30)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 30)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 30)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 30)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 30)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 30)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 30)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 30)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 30)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 30)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 30)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 30)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 30)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 30)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 30)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 30)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 30)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 30)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 30)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 30)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 30)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 30)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 30)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 30)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 30)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 30)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 30)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 30)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 30)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 30)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 30)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 30)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 30)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 30)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 30)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 30)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 30)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 30)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 30)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 30)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 30)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(30), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 30)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 30)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 30)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 30)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 30)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 30)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 30)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 30)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 30)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 30)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 30)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 30)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 30)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 30)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 30)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 30)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 30)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 30)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 30)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 30)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 30)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 30)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 30)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 30)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 30)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 30)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 30)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 30)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 30)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 30)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 30)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 30)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 30)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 30)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 30)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 30)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 30)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 30)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 30)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 30)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 30)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 30)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 30)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 30)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 30)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 30)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 30)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 30)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 30)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 30)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 30)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 30)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 30)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 30)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 30)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(30), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(30), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(29),
         GlitchData	=> P_GlitchData(29),
         OutSignalName	=> "P(29)",
         OutTemp	=> P_zd(29),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 29)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 29)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 29)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 29)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 29)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 29)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 29)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 29)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 29)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 29)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 29)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 29)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 29)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 29)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 29)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 29)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 29)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 29)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 29)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 29)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 29)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 29)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 29)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 29)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 29)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 29)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 29)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 29)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 29)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 29)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 29)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 29)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 29)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 29)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 29)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 29)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 29)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 29)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 29)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 29)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 29)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 29)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 29)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 29)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 29)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 29)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 29)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 29)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 29)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 29)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 29)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 29)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 29)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 29)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 29)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 29)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 29)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 29)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 29)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 29)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 29)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 29)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 29)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 29)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 29)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 29)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 29)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 29)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 29)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 29)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 29)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 29)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 29)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 29)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 29)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 29)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 29)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 29)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 29)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 29)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 29)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 29)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 29)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 29)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 29)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 29)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 29)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 29)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 29)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 29)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 29)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 29)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 29)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 29)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 29)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 29)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 29)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 29)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 29)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 29)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 29)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 29)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(29), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 29)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 29)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 29)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 29)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 29)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 29)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 29)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 29)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 29)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 29)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 29)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 29)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 29)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 29)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 29)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 29)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 29)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 29)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 29)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 29)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 29)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 29)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 29)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 29)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 29)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 29)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 29)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 29)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 29)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 29)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 29)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 29)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 29)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 29)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 29)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 29)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 29)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 29)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 29)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 29)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 29)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 29)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 29)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 29)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 29)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 29)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 29)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 29)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 29)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 29)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 29)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 29)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 29)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 29)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 29)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(29), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(29), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(28),
         GlitchData	=> P_GlitchData(28),
         OutSignalName	=> "P(28)",
         OutTemp	=> P_zd(28),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 28)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 28)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 28)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 28)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 28)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 28)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 28)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 28)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 28)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 28)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 28)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 28)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 28)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 28)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 28)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 28)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 28)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 28)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 28)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 28)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 28)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 28)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 28)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 28)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 28)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 28)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 28)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 28)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 28)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 28)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 28)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 28)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 28)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 28)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 28)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 28)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 28)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 28)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 28)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 28)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 28)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 28)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 28)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 28)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 28)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 28)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 28)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 28)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 28)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 28)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 28)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 28)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 28)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 28)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 28)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 28)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 28)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 28)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 28)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 28)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 28)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 28)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 28)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 28)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 28)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 28)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 28)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 28)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 28)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 28)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 28)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 28)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 28)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 28)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 28)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 28)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 28)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 28)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 28)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 28)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 28)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 28)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 28)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 28)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 28)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 28)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 28)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 28)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 28)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 28)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 28)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 28)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 28)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 28)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 28)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 28)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 28)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 28)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 28)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 28)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 28)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 28)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(28), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 28)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 28)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 28)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 28)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 28)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 28)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 28)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 28)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 28)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 28)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 28)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 28)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 28)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 28)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 28)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 28)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 28)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 28)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 28)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 28)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 28)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 28)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 28)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 28)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 28)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 28)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 28)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 28)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 28)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 28)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 28)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 28)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 28)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 28)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 28)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 28)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 28)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 28)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 28)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 28)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 28)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 28)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 28)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 28)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 28)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 28)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 28)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 28)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 28)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 28)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 28)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 28)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 28)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 28)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 28)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(28), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(28), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(27),
         GlitchData	=> P_GlitchData(27),
         OutSignalName	=> "P(27)",
         OutTemp	=> P_zd(27),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 27)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 27)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 27)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 27)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 27)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 27)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 27)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 27)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 27)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 27)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 27)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 27)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 27)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 27)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 27)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 27)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 27)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 27)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 27)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 27)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 27)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 27)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 27)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 27)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 27)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 27)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 27)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 27)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 27)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 27)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 27)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 27)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 27)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 27)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 27)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 27)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 27)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 27)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 27)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 27)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 27)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 27)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 27)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 27)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 27)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 27)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 27)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 27)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 27)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 27)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 27)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 27)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 27)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 27)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 27)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 27)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 27)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 27)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 27)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 27)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 27)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 27)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 27)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 27)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 27)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 27)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 27)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 27)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 27)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 27)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 27)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 27)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 27)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 27)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 27)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 27)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 27)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 27)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 27)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 27)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 27)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 27)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 27)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 27)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 27)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 27)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 27)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 27)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 27)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 27)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 27)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 27)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 27)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 27)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 27)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 27)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 27)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 27)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 27)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 27)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 27)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 27)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(27), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 27)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 27)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 27)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 27)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 27)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 27)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 27)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 27)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 27)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 27)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 27)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 27)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 27)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 27)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 27)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 27)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 27)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 27)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 27)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 27)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 27)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 27)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 27)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 27)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 27)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 27)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 27)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 27)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 27)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 27)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 27)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 27)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 27)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 27)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 27)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 27)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 27)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 27)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 27)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 27)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 27)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 27)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 27)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 27)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 27)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 27)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 27)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 27)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 27)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 27)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 27)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 27)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 27)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 27)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 27)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(27), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(27), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(26),
         GlitchData	=> P_GlitchData(26),
         OutSignalName	=> "P(26)",
         OutTemp	=> P_zd(26),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 26)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 26)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 26)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 26)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 26)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 26)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 26)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 26)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 26)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 26)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 26)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 26)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 26)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 26)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 26)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 26)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 26)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 26)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 26)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 26)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 26)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 26)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 26)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 26)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 26)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 26)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 26)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 26)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 26)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 26)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 26)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 26)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 26)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 26)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 26)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 26)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 26)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 26)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 26)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 26)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 26)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 26)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 26)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 26)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 26)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 26)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 26)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 26)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 26)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 26)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 26)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 26)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 26)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 26)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 26)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 26)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 26)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 26)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 26)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 26)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 26)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 26)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 26)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 26)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 26)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 26)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 26)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 26)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 26)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 26)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 26)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 26)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 26)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 26)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 26)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 26)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 26)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 26)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 26)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 26)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 26)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 26)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 26)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 26)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 26)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 26)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 26)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 26)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 26)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 26)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 26)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 26)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 26)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 26)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 26)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 26)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 26)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 26)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 26)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 26)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 26)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 26)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(26), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 26)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 26)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 26)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 26)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 26)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 26)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 26)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 26)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 26)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 26)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 26)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 26)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 26)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 26)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 26)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 26)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 26)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 26)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 26)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 26)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 26)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 26)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 26)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 26)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 26)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 26)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 26)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 26)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 26)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 26)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 26)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 26)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 26)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 26)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 26)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 26)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 26)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 26)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 26)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 26)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 26)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 26)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 26)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 26)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 26)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 26)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 26)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 26)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 26)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 26)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 26)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 26)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 26)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 26)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 26)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(26), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(26), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(25),
         GlitchData	=> P_GlitchData(25),
         OutSignalName	=> "P(25)",
         OutTemp	=> P_zd(25),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 25)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 25)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 25)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 25)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 25)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 25)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 25)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 25)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 25)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 25)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 25)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 25)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 25)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 25)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 25)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 25)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 25)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 25)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 25)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 25)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 25)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 25)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 25)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 25)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 25)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 25)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 25)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 25)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 25)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 25)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 25)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 25)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 25)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 25)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 25)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 25)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 25)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 25)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 25)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 25)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 25)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 25)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 25)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 25)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 25)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 25)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 25)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 25)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 25)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 25)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 25)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 25)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 25)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 25)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 25)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 25)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 25)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 25)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 25)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 25)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 25)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 25)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 25)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 25)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 25)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 25)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 25)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 25)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 25)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 25)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 25)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 25)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 25)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 25)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 25)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 25)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 25)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 25)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 25)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 25)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 25)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 25)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 25)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 25)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 25)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 25)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 25)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 25)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 25)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 25)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 25)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 25)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 25)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 25)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 25)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 25)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 25)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 25)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 25)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 25)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 25)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 25)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(25), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 25)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 25)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 25)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 25)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 25)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 25)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 25)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 25)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 25)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 25)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 25)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 25)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 25)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 25)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 25)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 25)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 25)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 25)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 25)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 25)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 25)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 25)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 25)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 25)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 25)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 25)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 25)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 25)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 25)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 25)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 25)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 25)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 25)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 25)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 25)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 25)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 25)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 25)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 25)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 25)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 25)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 25)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 25)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 25)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 25)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 25)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 25)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 25)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 25)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 25)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 25)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 25)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 25)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 25)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 25)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(25), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(25), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(24),
         GlitchData	=> P_GlitchData(24),
         OutSignalName	=> "P(24)",
         OutTemp	=> P_zd(24),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 24)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 24)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 24)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 24)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 24)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 24)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 24)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 24)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 24)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 24)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 24)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 24)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 24)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 24)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 24)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 24)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 24)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 24)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 24)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 24)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 24)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 24)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 24)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 24)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 24)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 24)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 24)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 24)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 24)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 24)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 24)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 24)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 24)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 24)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 24)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 24)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 24)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 24)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 24)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 24)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 24)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 24)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 24)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 24)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 24)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 24)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 24)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 24)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 24)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 24)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 24)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 24)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 24)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 24)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 24)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 24)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 24)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 24)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 24)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 24)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 24)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 24)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 24)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 24)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 24)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 24)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 24)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 24)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 24)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 24)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 24)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 24)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 24)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 24)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 24)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 24)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 24)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 24)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 24)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 24)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 24)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 24)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 24)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 24)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 24)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 24)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 24)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 24)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 24)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 24)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 24)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 24)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 24)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 24)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 24)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 24)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 24)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 24)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 24)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 24)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 24)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 24)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(24), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 24)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 24)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 24)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 24)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 24)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 24)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 24)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 24)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 24)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 24)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 24)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 24)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 24)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 24)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 24)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 24)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 24)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 24)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 24)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 24)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 24)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 24)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 24)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 24)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 24)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 24)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 24)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 24)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 24)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 24)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 24)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 24)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 24)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 24)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 24)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 24)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 24)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 24)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 24)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 24)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 24)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 24)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 24)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 24)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 24)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 24)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 24)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 24)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 24)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 24)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 24)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 24)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 24)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 24)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 24)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(24), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(24), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(23),
         GlitchData	=> P_GlitchData(23),
         OutSignalName	=> "P(23)",
         OutTemp	=> P_zd(23),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 23)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 23)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 23)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 23)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 23)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 23)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 23)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 23)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 23)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 23)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 23)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 23)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 23)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 23)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 23)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 23)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 23)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 23)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 23)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 23)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 23)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 23)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 23)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 23)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 23)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 23)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 23)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 23)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 23)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 23)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 23)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 23)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 23)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 23)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 23)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 23)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 23)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 23)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 23)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 23)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 23)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 23)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 23)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 23)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 23)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 23)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 23)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 23)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 23)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 23)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 23)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 23)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 23)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 23)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 23)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 23)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 23)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 23)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 23)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 23)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 23)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 23)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 23)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 23)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 23)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 23)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 23)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 23)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 23)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 23)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 23)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 23)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 23)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 23)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 23)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 23)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 23)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 23)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 23)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 23)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 23)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 23)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 23)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 23)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 23)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 23)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 23)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 23)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 23)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 23)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 23)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 23)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 23)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 23)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 23)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 23)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 23)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 23)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 23)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 23)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 23)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 23)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(23), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 23)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 23)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 23)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 23)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 23)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 23)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 23)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 23)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 23)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 23)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 23)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 23)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 23)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 23)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 23)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 23)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 23)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 23)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 23)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 23)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 23)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 23)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 23)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 23)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 23)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 23)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 23)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 23)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 23)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 23)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 23)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 23)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 23)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 23)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 23)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 23)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 23)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 23)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 23)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 23)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 23)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 23)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 23)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 23)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 23)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 23)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 23)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 23)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 23)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 23)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 23)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 23)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 23)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 23)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 23)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(23), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(23), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(22),
         GlitchData	=> P_GlitchData(22),
         OutSignalName	=> "P(22)",
         OutTemp	=> P_zd(22),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 22)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 22)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 22)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 22)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 22)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 22)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 22)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 22)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 22)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 22)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 22)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 22)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 22)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 22)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 22)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 22)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 22)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 22)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 22)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 22)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 22)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 22)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 22)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 22)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 22)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 22)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 22)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 22)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 22)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 22)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 22)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 22)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 22)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 22)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 22)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 22)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 22)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 22)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 22)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 22)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 22)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 22)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 22)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 22)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 22)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 22)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 22)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 22)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 22)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 22)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 22)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 22)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 22)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 22)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 22)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 22)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 22)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 22)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 22)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 22)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 22)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 22)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 22)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 22)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 22)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 22)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 22)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 22)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 22)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 22)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 22)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 22)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 22)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 22)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 22)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 22)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 22)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 22)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 22)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 22)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 22)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 22)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 22)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 22)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 22)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 22)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 22)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 22)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 22)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 22)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 22)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 22)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 22)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 22)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 22)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 22)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 22)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 22)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 22)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 22)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 22)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 22)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(22), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 22)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 22)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 22)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 22)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 22)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 22)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 22)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 22)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 22)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 22)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 22)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 22)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 22)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 22)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 22)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 22)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 22)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 22)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 22)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 22)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 22)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 22)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 22)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 22)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 22)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 22)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 22)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 22)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 22)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 22)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 22)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 22)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 22)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 22)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 22)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 22)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 22)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 22)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 22)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 22)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 22)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 22)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 22)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 22)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 22)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 22)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 22)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 22)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 22)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 22)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 22)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 22)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 22)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 22)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 22)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(22), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(22), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(21),
         GlitchData	=> P_GlitchData(21),
         OutSignalName	=> "P(21)",
         OutTemp	=> P_zd(21),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 21)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 21)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 21)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 21)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 21)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 21)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 21)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 21)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 21)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 21)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 21)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 21)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 21)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 21)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 21)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 21)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 21)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 21)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 21)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 21)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 21)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 21)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 21)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 21)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 21)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 21)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 21)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 21)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 21)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 21)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 21)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 21)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 21)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 21)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 21)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 21)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 21)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 21)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 21)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 21)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 21)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 21)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 21)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 21)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 21)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 21)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 21)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 21)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 21)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 21)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 21)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 21)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 21)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 21)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 21)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 21)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 21)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 21)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 21)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 21)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 21)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 21)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 21)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 21)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 21)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 21)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 21)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 21)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 21)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 21)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 21)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 21)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 21)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 21)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 21)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 21)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 21)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 21)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 21)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 21)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 21)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 21)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 21)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 21)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 21)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 21)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 21)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 21)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 21)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 21)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 21)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 21)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 21)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 21)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 21)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 21)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 21)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 21)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 21)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 21)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 21)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 21)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(21), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 21)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 21)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 21)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 21)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 21)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 21)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 21)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 21)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 21)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 21)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 21)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 21)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 21)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 21)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 21)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 21)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 21)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 21)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 21)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 21)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 21)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 21)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 21)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 21)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 21)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 21)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 21)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 21)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 21)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 21)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 21)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 21)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 21)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 21)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 21)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 21)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 21)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 21)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 21)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 21)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 21)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 21)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 21)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 21)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 21)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 21)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 21)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 21)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 21)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 21)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 21)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 21)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 21)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 21)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 21)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(21), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(21), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(20),
         GlitchData	=> P_GlitchData(20),
         OutSignalName	=> "P(20)",
         OutTemp	=> P_zd(20),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 20)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 20)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 20)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 20)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 20)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 20)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 20)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 20)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 20)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 20)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 20)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 20)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 20)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 20)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 20)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 20)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 20)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 20)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 20)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 20)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 20)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 20)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 20)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 20)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 20)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 20)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 20)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 20)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 20)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 20)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 20)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 20)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 20)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 20)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 20)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 20)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 20)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 20)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 20)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 20)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 20)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 20)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 20)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 20)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 20)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 20)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 20)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 20)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 20)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 20)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 20)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 20)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 20)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 20)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 20)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 20)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 20)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 20)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 20)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 20)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 20)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 20)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 20)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 20)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 20)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 20)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 20)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 20)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 20)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 20)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 20)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 20)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 20)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 20)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 20)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 20)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 20)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 20)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 20)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 20)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 20)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 20)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 20)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 20)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 20)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 20)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 20)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 20)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 20)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 20)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 20)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 20)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 20)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 20)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 20)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 20)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 20)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 20)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 20)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 20)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 20)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 20)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(20), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 20)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 20)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 20)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 20)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 20)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 20)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 20)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 20)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 20)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 20)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 20)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 20)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 20)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 20)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 20)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 20)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 20)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 20)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 20)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 20)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 20)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 20)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 20)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 20)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 20)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 20)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 20)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 20)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 20)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 20)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 20)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 20)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 20)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 20)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 20)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 20)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 20)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 20)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 20)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 20)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 20)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 20)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 20)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 20)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 20)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 20)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 20)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 20)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 20)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 20)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 20)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 20)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 20)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 20)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 20)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(20), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(20), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(19),
         GlitchData	=> P_GlitchData(19),
         OutSignalName	=> "P(19)",
         OutTemp	=> P_zd(19),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 19)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 19)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 19)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 19)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 19)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 19)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 19)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 19)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 19)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 19)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 19)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 19)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 19)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 19)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 19)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 19)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 19)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 19)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 19)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 19)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 19)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 19)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 19)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 19)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 19)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 19)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 19)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 19)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 19)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 19)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 19)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 19)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 19)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 19)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 19)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 19)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 19)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 19)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 19)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 19)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 19)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 19)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 19)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 19)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 19)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 19)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 19)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 19)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 19)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 19)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 19)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 19)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 19)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 19)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 19)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 19)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 19)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 19)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 19)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 19)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 19)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 19)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 19)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 19)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 19)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 19)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 19)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 19)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 19)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 19)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 19)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 19)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 19)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 19)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 19)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 19)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 19)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 19)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 19)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 19)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 19)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 19)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 19)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 19)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 19)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 19)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 19)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 19)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 19)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 19)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 19)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 19)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 19)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 19)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 19)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 19)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 19)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 19)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 19)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 19)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 19)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 19)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(19), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 19)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 19)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 19)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 19)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 19)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 19)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 19)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 19)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 19)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 19)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 19)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 19)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 19)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 19)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 19)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 19)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 19)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 19)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 19)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 19)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 19)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 19)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 19)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 19)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 19)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 19)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 19)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 19)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 19)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 19)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 19)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 19)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 19)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 19)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 19)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 19)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 19)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 19)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 19)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 19)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 19)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 19)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 19)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 19)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 19)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 19)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 19)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 19)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 19)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 19)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 19)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 19)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 19)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 19)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 19)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(19), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(19), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(18),
         GlitchData	=> P_GlitchData(18),
         OutSignalName	=> "P(18)",
         OutTemp	=> P_zd(18),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 18)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 18)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 18)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 18)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 18)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 18)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 18)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 18)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 18)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 18)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 18)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 18)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 18)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 18)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 18)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 18)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 18)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 18)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 18)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 18)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 18)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 18)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 18)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 18)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 18)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 18)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 18)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 18)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 18)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 18)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 18)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 18)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 18)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 18)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 18)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 18)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 18)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 18)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 18)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 18)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 18)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 18)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 18)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 18)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 18)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 18)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 18)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 18)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 18)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 18)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 18)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 18)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 18)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 18)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 18)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 18)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 18)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 18)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 18)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 18)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 18)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 18)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 18)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 18)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 18)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 18)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 18)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 18)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 18)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 18)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 18)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 18)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 18)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 18)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 18)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 18)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 18)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 18)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 18)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 18)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 18)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 18)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 18)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 18)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 18)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 18)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 18)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 18)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 18)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 18)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 18)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 18)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 18)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 18)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 18)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 18)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 18)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 18)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 18)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 18)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 18)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 18)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(18), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 18)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 18)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 18)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 18)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 18)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 18)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 18)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 18)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 18)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 18)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 18)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 18)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 18)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 18)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 18)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 18)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 18)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 18)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 18)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 18)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 18)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 18)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 18)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 18)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 18)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 18)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 18)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 18)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 18)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 18)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 18)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 18)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 18)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 18)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 18)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 18)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 18)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 18)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 18)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 18)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 18)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 18)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 18)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 18)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 18)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 18)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 18)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 18)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 18)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 18)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 18)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 18)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 18)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 18)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 18)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(18), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(18), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(17),
         GlitchData	=> P_GlitchData(17),
         OutSignalName	=> "P(17)",
         OutTemp	=> P_zd(17),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 17)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 17)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 17)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 17)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 17)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 17)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 17)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 17)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 17)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 17)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 17)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 17)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 17)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 17)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 17)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 17)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 17)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 17)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 17)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 17)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 17)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 17)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 17)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 17)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 17)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 17)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 17)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 17)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 17)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 17)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 17)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 17)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 17)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 17)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 17)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 17)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 17)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 17)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 17)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 17)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 17)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 17)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 17)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 17)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 17)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 17)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 17)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 17)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 17)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 17)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 17)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 17)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 17)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 17)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 17)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 17)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 17)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 17)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 17)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 17)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 17)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 17)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 17)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 17)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 17)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 17)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 17)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 17)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 17)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 17)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 17)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 17)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 17)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 17)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 17)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 17)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 17)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 17)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 17)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 17)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 17)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 17)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 17)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 17)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 17)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 17)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 17)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 17)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 17)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 17)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 17)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 17)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 17)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 17)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 17)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 17)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 17)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 17)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 17)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 17)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 17)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 17)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(17), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 17)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 17)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 17)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 17)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 17)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 17)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 17)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 17)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 17)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 17)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 17)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 17)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 17)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 17)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 17)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 17)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 17)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 17)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 17)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 17)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 17)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 17)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 17)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 17)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 17)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 17)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 17)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 17)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 17)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 17)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 17)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 17)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 17)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 17)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 17)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 17)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 17)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 17)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 17)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 17)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 17)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 17)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 17)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 17)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 17)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 17)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 17)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 17)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 17)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 17)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 17)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 17)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 17)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 17)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 17)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(17), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(17), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(16),
         GlitchData	=> P_GlitchData(16),
         OutSignalName	=> "P(16)",
         OutTemp	=> P_zd(16),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 16)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 16)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 16)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 16)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 16)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 16)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 16)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 16)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 16)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 16)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 16)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 16)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 16)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 16)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 16)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 16)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 16)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 16)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 16)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 16)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 16)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 16)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 16)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 16)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 16)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 16)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 16)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 16)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 16)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 16)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 16)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 16)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 16)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 16)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 16)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 16)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 16)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 16)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 16)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 16)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 16)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 16)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 16)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 16)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 16)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 16)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 16)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 16)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 16)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 16)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 16)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 16)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 16)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 16)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 16)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 16)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 16)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 16)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 16)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 16)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 16)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 16)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 16)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 16)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 16)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 16)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 16)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 16)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 16)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 16)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 16)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 16)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 16)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 16)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 16)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 16)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 16)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 16)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 16)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 16)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 16)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 16)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 16)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 16)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 16)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 16)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 16)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 16)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 16)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 16)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 16)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 16)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 16)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 16)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 16)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 16)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 16)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 16)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 16)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 16)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 16)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 16)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(16), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 16)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 16)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 16)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 16)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 16)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 16)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 16)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 16)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 16)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 16)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 16)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 16)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 16)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 16)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 16)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 16)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 16)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 16)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 16)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 16)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 16)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 16)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 16)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 16)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 16)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 16)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 16)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 16)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 16)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 16)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 16)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 16)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 16)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 16)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 16)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 16)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 16)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 16)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 16)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 16)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 16)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 16)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 16)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 16)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 16)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 16)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 16)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 16)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 16)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 16)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 16)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 16)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 16)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 16)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 16)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(16), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(16), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(15),
         GlitchData	=> P_GlitchData(15),
         OutSignalName	=> "P(15)",
         OutTemp	=> P_zd(15),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 15)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 15)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 15)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 15)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 15)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 15)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 15)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 15)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 15)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 15)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 15)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 15)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 15)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 15)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 15)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 15)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 15)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 15)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 15)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 15)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 15)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 15)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 15)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 15)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 15)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 15)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 15)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 15)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 15)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 15)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 15)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 15)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 15)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 15)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 15)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 15)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 15)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 15)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 15)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 15)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 15)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 15)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 15)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 15)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 15)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 15)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 15)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 15)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 15)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 15)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 15)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 15)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 15)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 15)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 15)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 15)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 15)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 15)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 15)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 15)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 15)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 15)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 15)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 15)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 15)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 15)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 15)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 15)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 15)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 15)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 15)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 15)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 15)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 15)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 15)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 15)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 15)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 15)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 15)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 15)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 15)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 15)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 15)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 15)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 15)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 15)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 15)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 15)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 15)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 15)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 15)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 15)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 15)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 15)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 15)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 15)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 15)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 15)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 15)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 15)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 15)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 15)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(15), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 15)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 15)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 15)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 15)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 15)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 15)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 15)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 15)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 15)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 15)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 15)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 15)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 15)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 15)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 15)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 15)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 15)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 15)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 15)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 15)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 15)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 15)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 15)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 15)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 15)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 15)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 15)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 15)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 15)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 15)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 15)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 15)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 15)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 15)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 15)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 15)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 15)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 15)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 15)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 15)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 15)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 15)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 15)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 15)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 15)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 15)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 15)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 15)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 15)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 15)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 15)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 15)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 15)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 15)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 15)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(15), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(15), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(14),
         GlitchData	=> P_GlitchData(14),
         OutSignalName	=> "P(14)",
         OutTemp	=> P_zd(14),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 14)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 14)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 14)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 14)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 14)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 14)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 14)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 14)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 14)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 14)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 14)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 14)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 14)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 14)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 14)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 14)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 14)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 14)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 14)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 14)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 14)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 14)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 14)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 14)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 14)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 14)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 14)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 14)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 14)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 14)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 14)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 14)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 14)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 14)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 14)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 14)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 14)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 14)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 14)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 14)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 14)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 14)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 14)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 14)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 14)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 14)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 14)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 14)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 14)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 14)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 14)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 14)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 14)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 14)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 14)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 14)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 14)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 14)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 14)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 14)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 14)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 14)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 14)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 14)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 14)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 14)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 14)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 14)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 14)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 14)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 14)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 14)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 14)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 14)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 14)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 14)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 14)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 14)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 14)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 14)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 14)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 14)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 14)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 14)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 14)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 14)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 14)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 14)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 14)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 14)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 14)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 14)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 14)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 14)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 14)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 14)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 14)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 14)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 14)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 14)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 14)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 14)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(14), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 14)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 14)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 14)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 14)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 14)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 14)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 14)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 14)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 14)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 14)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 14)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 14)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 14)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 14)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 14)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 14)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 14)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 14)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 14)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 14)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 14)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 14)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 14)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 14)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 14)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 14)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 14)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 14)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 14)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 14)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 14)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 14)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 14)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 14)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 14)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 14)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 14)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 14)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 14)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 14)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 14)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 14)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 14)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 14)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 14)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 14)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 14)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 14)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 14)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 14)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 14)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 14)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 14)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 14)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 14)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(14), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(14), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(13),
         GlitchData	=> P_GlitchData(13),
         OutSignalName	=> "P(13)",
         OutTemp	=> P_zd(13),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 13)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 13)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 13)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 13)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 13)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 13)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 13)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 13)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 13)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 13)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 13)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 13)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 13)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 13)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 13)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 13)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 13)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 13)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 13)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 13)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 13)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 13)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 13)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 13)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 13)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 13)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 13)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 13)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 13)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 13)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 13)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 13)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 13)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 13)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 13)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 13)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 13)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 13)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 13)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 13)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 13)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 13)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 13)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 13)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 13)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 13)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 13)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 13)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 13)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 13)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 13)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 13)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 13)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 13)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 13)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 13)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 13)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 13)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 13)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 13)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 13)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 13)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 13)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 13)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 13)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 13)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 13)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 13)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 13)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 13)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 13)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 13)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 13)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 13)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 13)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 13)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 13)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 13)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 13)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 13)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 13)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 13)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 13)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 13)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 13)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 13)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 13)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 13)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 13)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 13)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 13)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 13)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 13)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 13)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 13)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 13)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 13)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 13)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 13)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 13)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 13)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 13)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(13), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 13)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 13)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 13)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 13)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 13)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 13)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 13)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 13)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 13)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 13)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 13)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 13)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 13)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 13)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 13)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 13)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 13)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 13)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 13)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 13)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 13)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 13)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 13)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 13)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 13)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 13)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 13)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 13)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 13)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 13)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 13)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 13)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 13)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 13)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 13)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 13)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 13)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 13)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 13)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 13)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 13)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 13)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 13)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 13)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 13)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 13)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 13)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 13)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 13)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 13)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 13)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 13)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 13)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 13)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 13)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(13), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(13), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(12),
         GlitchData	=> P_GlitchData(12),
         OutSignalName	=> "P(12)",
         OutTemp	=> P_zd(12),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 12)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 12)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 12)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 12)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 12)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 12)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 12)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 12)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 12)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 12)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 12)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 12)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 12)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 12)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 12)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 12)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 12)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 12)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 12)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 12)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 12)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 12)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 12)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 12)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 12)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 12)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 12)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 12)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 12)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 12)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 12)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 12)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 12)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 12)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 12)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 12)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 12)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 12)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 12)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 12)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 12)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 12)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 12)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 12)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 12)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 12)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 12)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 12)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 12)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 12)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 12)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 12)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 12)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 12)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 12)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 12)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 12)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 12)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 12)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 12)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 12)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 12)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 12)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 12)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 12)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 12)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 12)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 12)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 12)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 12)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 12)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 12)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 12)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 12)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 12)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 12)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 12)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 12)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 12)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 12)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 12)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 12)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 12)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 12)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 12)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 12)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 12)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 12)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 12)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 12)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 12)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 12)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 12)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 12)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 12)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 12)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 12)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 12)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 12)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 12)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 12)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 12)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(12), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 12)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 12)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 12)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 12)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 12)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 12)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 12)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 12)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 12)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 12)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 12)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 12)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 12)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 12)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 12)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 12)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 12)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 12)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 12)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 12)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 12)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 12)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 12)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 12)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 12)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 12)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 12)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 12)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 12)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 12)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 12)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 12)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 12)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 12)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 12)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 12)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 12)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 12)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 12)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 12)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 12)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 12)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 12)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 12)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 12)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 12)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 12)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 12)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 12)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 12)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 12)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 12)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 12)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 12)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 12)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(12), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(12), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(11),
         GlitchData	=> P_GlitchData(11),
         OutSignalName	=> "P(11)",
         OutTemp	=> P_zd(11),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 11)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 11)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 11)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 11)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 11)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 11)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 11)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 11)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 11)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 11)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 11)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 11)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 11)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 11)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 11)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 11)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 11)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 11)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 11)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 11)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 11)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 11)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 11)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 11)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 11)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 11)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 11)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 11)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 11)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 11)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 11)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 11)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 11)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 11)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 11)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 11)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 11)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 11)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 11)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 11)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 11)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 11)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 11)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 11)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 11)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 11)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 11)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 11)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 11)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 11)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 11)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 11)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 11)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 11)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 11)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 11)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 11)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 11)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 11)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 11)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 11)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 11)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 11)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 11)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 11)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 11)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 11)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 11)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 11)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 11)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 11)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 11)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 11)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 11)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 11)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 11)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 11)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 11)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 11)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 11)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 11)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 11)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 11)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 11)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 11)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 11)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 11)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 11)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 11)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 11)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 11)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 11)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 11)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 11)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 11)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 11)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 11)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 11)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 11)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 11)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 11)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 11)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(11), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 11)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 11)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 11)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 11)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 11)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 11)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 11)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 11)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 11)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 11)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 11)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 11)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 11)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 11)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 11)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 11)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 11)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 11)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 11)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 11)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 11)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 11)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 11)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 11)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 11)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 11)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 11)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 11)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 11)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 11)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 11)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 11)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 11)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 11)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 11)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 11)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 11)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 11)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 11)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 11)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 11)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 11)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 11)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 11)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 11)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 11)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 11)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 11)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 11)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 11)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 11)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 11)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 11)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 11)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 11)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(11), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(11), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(10),
         GlitchData	=> P_GlitchData(10),
         OutSignalName	=> "P(10)",
         OutTemp	=> P_zd(10),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 10)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 10)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 10)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 10)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 10)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 10)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 10)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 10)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 10)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 10)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 10)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 10)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 10)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 10)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 10)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 10)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 10)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 10)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 10)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 10)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 10)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 10)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 10)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 10)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 10)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 10)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 10)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 10)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 10)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 10)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 10)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 10)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 10)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 10)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 10)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 10)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 10)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 10)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 10)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 10)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 10)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 10)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 10)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 10)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 10)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 10)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 10)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 10)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 10)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 10)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 10)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 10)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 10)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 10)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 10)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 10)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 10)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 10)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 10)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 10)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 10)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 10)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 10)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 10)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 10)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 10)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 10)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 10)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 10)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 10)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 10)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 10)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 10)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 10)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 10)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 10)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 10)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 10)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 10)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 10)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 10)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 10)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 10)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 10)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 10)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 10)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 10)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 10)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 10)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 10)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 10)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 10)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 10)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 10)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 10)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 10)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 10)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 10)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 10)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 10)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 10)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 10)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(10), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 10)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 10)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 10)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 10)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 10)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 10)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 10)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 10)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 10)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 10)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 10)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 10)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 10)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 10)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 10)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 10)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 10)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 10)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 10)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 10)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 10)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 10)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 10)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 10)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 10)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 10)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 10)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 10)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 10)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 10)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 10)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 10)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 10)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 10)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 10)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 10)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 10)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 10)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 10)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 10)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 10)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 10)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 10)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 10)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 10)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 10)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 10)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 10)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 10)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 10)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 10)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 10)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 10)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 10)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 10)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(10), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(10), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(9),
         GlitchData	=> P_GlitchData(9),
         OutSignalName	=> "P(9)",
         OutTemp	=> P_zd(9),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 9)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 9)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 9)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 9)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 9)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 9)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 9)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 9)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 9)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 9)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 9)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 9)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 9)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 9)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 9)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 9)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 9)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 9)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 9)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 9)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 9)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 9)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 9)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 9)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 9)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 9)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 9)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 9)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 9)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 9)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 9)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 9)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 9)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 9)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 9)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 9)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 9)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 9)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 9)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 9)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 9)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 9)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 9)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 9)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 9)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 9)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 9)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 9)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 9)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 9)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 9)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 9)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 9)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 9)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 9)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 9)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 9)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 9)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 9)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 9)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 9)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 9)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 9)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 9)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 9)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 9)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 9)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 9)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 9)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 9)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 9)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 9)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 9)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 9)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 9)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 9)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 9)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 9)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 9)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 9)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 9)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 9)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 9)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 9)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 9)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 9)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 9)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 9)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 9)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 9)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 9)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 9)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 9)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 9)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 9)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 9)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 9)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 9)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 9)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 9)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 9)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 9)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(9), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 9)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 9)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 9)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 9)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 9)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 9)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 9)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 9)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 9)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 9)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 9)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 9)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 9)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 9)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 9)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 9)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 9)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 9)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 9)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 9)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 9)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 9)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 9)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 9)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 9)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 9)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 9)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 9)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 9)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 9)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 9)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 9)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 9)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 9)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 9)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 9)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 9)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 9)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 9)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 9)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 9)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 9)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 9)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 9)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 9)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 9)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 9)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 9)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 9)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 9)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 9)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 9)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 9)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 9)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 9)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(9), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(9), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(8),
         GlitchData	=> P_GlitchData(8),
         OutSignalName	=> "P(8)",
         OutTemp	=> P_zd(8),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 8)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 8)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 8)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 8)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 8)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 8)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 8)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 8)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 8)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 8)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 8)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 8)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 8)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 8)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 8)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 8)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 8)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 8)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 8)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 8)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 8)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 8)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 8)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 8)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 8)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 8)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 8)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 8)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 8)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 8)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 8)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 8)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 8)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 8)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 8)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 8)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 8)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 8)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 8)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 8)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 8)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 8)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 8)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 8)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 8)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 8)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 8)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 8)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 8)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 8)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 8)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 8)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 8)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 8)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 8)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 8)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 8)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 8)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 8)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 8)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 8)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 8)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 8)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 8)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 8)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 8)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 8)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 8)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 8)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 8)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 8)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 8)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 8)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 8)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 8)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 8)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 8)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 8)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 8)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 8)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 8)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 8)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 8)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 8)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 8)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 8)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 8)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 8)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 8)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 8)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 8)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 8)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 8)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 8)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 8)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 8)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 8)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 8)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 8)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 8)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 8)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 8)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(8), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 8)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 8)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 8)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 8)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 8)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 8)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 8)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 8)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 8)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 8)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 8)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 8)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 8)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 8)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 8)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 8)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 8)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 8)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 8)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 8)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 8)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 8)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 8)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 8)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 8)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 8)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 8)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 8)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 8)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 8)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 8)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 8)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 8)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 8)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 8)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 8)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 8)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 8)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 8)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 8)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 8)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 8)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 8)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 8)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 8)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 8)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 8)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 8)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 8)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 8)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 8)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 8)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 8)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 8)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 8)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(8), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(8), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(7),
         GlitchData	=> P_GlitchData(7),
         OutSignalName	=> "P(7)",
         OutTemp	=> P_zd(7),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 7)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 7)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 7)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 7)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 7)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 7)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 7)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 7)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 7)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 7)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 7)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 7)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 7)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 7)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 7)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 7)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 7)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 7)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 7)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 7)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 7)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 7)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 7)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 7)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 7)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 7)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 7)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 7)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 7)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 7)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 7)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 7)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 7)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 7)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 7)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 7)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 7)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 7)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 7)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 7)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 7)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 7)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 7)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 7)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 7)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 7)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 7)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 7)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 7)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 7)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 7)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 7)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 7)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 7)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 7)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 7)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 7)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 7)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 7)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 7)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 7)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 7)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 7)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 7)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 7)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 7)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 7)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 7)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 7)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 7)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 7)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 7)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 7)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 7)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 7)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 7)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 7)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 7)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 7)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 7)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 7)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 7)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 7)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 7)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 7)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 7)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 7)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 7)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 7)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 7)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 7)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 7)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 7)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 7)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 7)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 7)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 7)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 7)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 7)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 7)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 7)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 7)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(7), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 7)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 7)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 7)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 7)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 7)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 7)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 7)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 7)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 7)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 7)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 7)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 7)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 7)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 7)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 7)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 7)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 7)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 7)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 7)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 7)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 7)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 7)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 7)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 7)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 7)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 7)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 7)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 7)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 7)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 7)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 7)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 7)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 7)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 7)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 7)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 7)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 7)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 7)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 7)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 7)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 7)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 7)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 7)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 7)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 7)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 7)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 7)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 7)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 7)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 7)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 7)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 7)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 7)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 7)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 7)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(7), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(7), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(6),
         GlitchData	=> P_GlitchData(6),
         OutSignalName	=> "P(6)",
         OutTemp	=> P_zd(6),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 6)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 6)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 6)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 6)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 6)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 6)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 6)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 6)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 6)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 6)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 6)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 6)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 6)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 6)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 6)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 6)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 6)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 6)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 6)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 6)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 6)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 6)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 6)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 6)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 6)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 6)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 6)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 6)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 6)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 6)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 6)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 6)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 6)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 6)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 6)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 6)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 6)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 6)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 6)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 6)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 6)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 6)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 6)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 6)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 6)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 6)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 6)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 6)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 6)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 6)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 6)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 6)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 6)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 6)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 6)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 6)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 6)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 6)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 6)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 6)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 6)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 6)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 6)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 6)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 6)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 6)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 6)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 6)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 6)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 6)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 6)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 6)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 6)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 6)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 6)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 6)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 6)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 6)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 6)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 6)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 6)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 6)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 6)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 6)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 6)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 6)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 6)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 6)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 6)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 6)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 6)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 6)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 6)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 6)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 6)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 6)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 6)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 6)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 6)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 6)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 6)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 6)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(6), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 6)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 6)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 6)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 6)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 6)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 6)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 6)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 6)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 6)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 6)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 6)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 6)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 6)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 6)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 6)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 6)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 6)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 6)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 6)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 6)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 6)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 6)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 6)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 6)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 6)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 6)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 6)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 6)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 6)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 6)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 6)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 6)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 6)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 6)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 6)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 6)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 6)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 6)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 6)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 6)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 6)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 6)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 6)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 6)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 6)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 6)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 6)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 6)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 6)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 6)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 6)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 6)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 6)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 6)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 6)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(6), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(6), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(5),
         GlitchData	=> P_GlitchData(5),
         OutSignalName	=> "P(5)",
         OutTemp	=> P_zd(5),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 5)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 5)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 5)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 5)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 5)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 5)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 5)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 5)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 5)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 5)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 5)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 5)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 5)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 5)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 5)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 5)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 5)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 5)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 5)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 5)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 5)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 5)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 5)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 5)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 5)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 5)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 5)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 5)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 5)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 5)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 5)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 5)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 5)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 5)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 5)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 5)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 5)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 5)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 5)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 5)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 5)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 5)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 5)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 5)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 5)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 5)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 5)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 5)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 5)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 5)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 5)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 5)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 5)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 5)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 5)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 5)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 5)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 5)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 5)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 5)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 5)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 5)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 5)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 5)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 5)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 5)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 5)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 5)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 5)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 5)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 5)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 5)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 5)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 5)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 5)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 5)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 5)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 5)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 5)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 5)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 5)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 5)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 5)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 5)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 5)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 5)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 5)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 5)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 5)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 5)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 5)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 5)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 5)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 5)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 5)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 5)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 5)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 5)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 5)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 5)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 5)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 5)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(5), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 5)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 5)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 5)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 5)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 5)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 5)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 5)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 5)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 5)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 5)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 5)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 5)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 5)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 5)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 5)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 5)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 5)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 5)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 5)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 5)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 5)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 5)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 5)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 5)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 5)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 5)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 5)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 5)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 5)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 5)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 5)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 5)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 5)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 5)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 5)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 5)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 5)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 5)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 5)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 5)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 5)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 5)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 5)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 5)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 5)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 5)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 5)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 5)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 5)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 5)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 5)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 5)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 5)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 5)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 5)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(5), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(5), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(4),
         GlitchData	=> P_GlitchData(4),
         OutSignalName	=> "P(4)",
         OutTemp	=> P_zd(4),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 4)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 4)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 4)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 4)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 4)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 4)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 4)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 4)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 4)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 4)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 4)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 4)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 4)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 4)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 4)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 4)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 4)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 4)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 4)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 4)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 4)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 4)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 4)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 4)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 4)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 4)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 4)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 4)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 4)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 4)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 4)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 4)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 4)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 4)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 4)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 4)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 4)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 4)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 4)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 4)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 4)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 4)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 4)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 4)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 4)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 4)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 4)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 4)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 4)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 4)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 4)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 4)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 4)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 4)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 4)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 4)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 4)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 4)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 4)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 4)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 4)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 4)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 4)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 4)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 4)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 4)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 4)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 4)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 4)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 4)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 4)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 4)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 4)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 4)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 4)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 4)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 4)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 4)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 4)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 4)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 4)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 4)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 4)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 4)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 4)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 4)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 4)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 4)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 4)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 4)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 4)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 4)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 4)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 4)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 4)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 4)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 4)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 4)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 4)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 4)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 4)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 4)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(4), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 4)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 4)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 4)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 4)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 4)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 4)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 4)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 4)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 4)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 4)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 4)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 4)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 4)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 4)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 4)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 4)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 4)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 4)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 4)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 4)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 4)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 4)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 4)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 4)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 4)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 4)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 4)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 4)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 4)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 4)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 4)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 4)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 4)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 4)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 4)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 4)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 4)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 4)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 4)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 4)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 4)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 4)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 4)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 4)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 4)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 4)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 4)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 4)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 4)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 4)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 4)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 4)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 4)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 4)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 4)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(4), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(4), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(3),
         GlitchData	=> P_GlitchData(3),
         OutSignalName	=> "P(3)",
         OutTemp	=> P_zd(3),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 3)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 3)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 3)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 3)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 3)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 3)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 3)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 3)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 3)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 3)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 3)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 3)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 3)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 3)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 3)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 3)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 3)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 3)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 3)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 3)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 3)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 3)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 3)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 3)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 3)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 3)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 3)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 3)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 3)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 3)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 3)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 3)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 3)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 3)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 3)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 3)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 3)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 3)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 3)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 3)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 3)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 3)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 3)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 3)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 3)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 3)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 3)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 3)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 3)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 3)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 3)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 3)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 3)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 3)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 3)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 3)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 3)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 3)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 3)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 3)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 3)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 3)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 3)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 3)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 3)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 3)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 3)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 3)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 3)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 3)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 3)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 3)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 3)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 3)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 3)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 3)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 3)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 3)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 3)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 3)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 3)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 3)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 3)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 3)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 3)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 3)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 3)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 3)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 3)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 3)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 3)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 3)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 3)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 3)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 3)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 3)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 3)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 3)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 3)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 3)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 3)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 3)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(3), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 3)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 3)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 3)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 3)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 3)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 3)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 3)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 3)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 3)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 3)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 3)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 3)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 3)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 3)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 3)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 3)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 3)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 3)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 3)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 3)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 3)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 3)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 3)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 3)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 3)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 3)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 3)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 3)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 3)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 3)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 3)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 3)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 3)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 3)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 3)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 3)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 3)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 3)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 3)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 3)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 3)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 3)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 3)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 3)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 3)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 3)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 3)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 3)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 3)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 3)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 3)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 3)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 3)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 3)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 3)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(3), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(3), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(2),
         GlitchData	=> P_GlitchData(2),
         OutSignalName	=> "P(2)",
         OutTemp	=> P_zd(2),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 2)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 2)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 2)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 2)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 2)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 2)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 2)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 2)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 2)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 2)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 2)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 2)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 2)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 2)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 2)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 2)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 2)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 2)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 2)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 2)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 2)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 2)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 2)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 2)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 2)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 2)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 2)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 2)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 2)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 2)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 2)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 2)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 2)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 2)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 2)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 2)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 2)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 2)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 2)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 2)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 2)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 2)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 2)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 2)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 2)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 2)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 2)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 2)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 2)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 2)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 2)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 2)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 2)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 2)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 2)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 2)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 2)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 2)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 2)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 2)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 2)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 2)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 2)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 2)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 2)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 2)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 2)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 2)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 2)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 2)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 2)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 2)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 2)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 2)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 2)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 2)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 2)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 2)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 2)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 2)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 2)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 2)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 2)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 2)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 2)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 2)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 2)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 2)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 2)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 2)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 2)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 2)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 2)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 2)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 2)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 2)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 2)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 2)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 2)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 2)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 2)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 2)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(2), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 2)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 2)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 2)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 2)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 2)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 2)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 2)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 2)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 2)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 2)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 2)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 2)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 2)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 2)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 2)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 2)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 2)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 2)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 2)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 2)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 2)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 2)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 2)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 2)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 2)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 2)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 2)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 2)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 2)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 2)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 2)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 2)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 2)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 2)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 2)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 2)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 2)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 2)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 2)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 2)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 2)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 2)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 2)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 2)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 2)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 2)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 2)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 2)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 2)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 2)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 2)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 2)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 2)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 2)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 2)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(2), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(2), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(1),
         GlitchData	=> P_GlitchData(1),
         OutSignalName	=> "P(1)",
         OutTemp	=> P_zd(1),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 1)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 1)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 1)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 1)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 1)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 1)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 1)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 1)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 1)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 1)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 1)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 1)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 1)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 1)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 1)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 1)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 1)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 1)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 1)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 1)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 1)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 1)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 1)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 1)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 1)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 1)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 1)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 1)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 1)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 1)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 1)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 1)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 1)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 1)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 1)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 1)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 1)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 1)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 1)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 1)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 1)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 1)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 1)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 1)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 1)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 1)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 1)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 1)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 1)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 1)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 1)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 1)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 1)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 1)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 1)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 1)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 1)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 1)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 1)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 1)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 1)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 1)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 1)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 1)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 1)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 1)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 1)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 1)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 1)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 1)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 1)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 1)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 1)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 1)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 1)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 1)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 1)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 1)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 1)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 1)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 1)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 1)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 1)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 1)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 1)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 1)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 1)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 1)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 1)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 1)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 1)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 1)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 1)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 1)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 1)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 1)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 1)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 1)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 1)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 1)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 1)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 1)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(1), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 1)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 1)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 1)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 1)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 1)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 1)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 1)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 1)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 1)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 1)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 1)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 1)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 1)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 1)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 1)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 1)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 1)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 1)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 1)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 1)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 1)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 1)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 1)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 1)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 1)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 1)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 1)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 1)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 1)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 1)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 1)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 1)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 1)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 1)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 1)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 1)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 1)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 1)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 1)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 1)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 1)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 1)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 1)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 1)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 1)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 1)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 1)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 1)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 1)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 1)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 1)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 1)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 1)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 1)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 1)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(1), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(1), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> P(0),
         GlitchData	=> P_GlitchData(0),
         OutSignalName	=> "P(0)",
         OutTemp	=> P_zd(0),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_P((863 - 0)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_P((863 - 0)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_P((863 - 0)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_P((863 - 0)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_P((863 - 0)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_P((863 - 0)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_P((863 - 0)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_P((863 - 0)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_P((863 - 0)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_P((863 - 0)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_P((863 - 0)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_P((863 - 0)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_P((863 - 0)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_P((863 - 0)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_P((863 - 0)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_P((863 - 0)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_P((863 - 0)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_P((863 - 0)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_P((863 - 0)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_P((863 - 0)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_P((863 - 0)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_P((863 - 0)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_P((863 - 0)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_P((863 - 0)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_P((863 - 0)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_P((863 - 0)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_P((863 - 0)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_P((863 - 0)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_P((863 - 0)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_P((863 - 0)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_P((863 - 0)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_P((863 - 0)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_P((863 - 0)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_P((863 - 0)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_P((863 - 0)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_P((863 - 0)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_P((863 - 0)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_P((863 - 0)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_P((863 - 0)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_P((863 - 0)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_P((863 - 0)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_P((863 - 0)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_P((863 - 0)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_P((863 - 0)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_P((863 - 0)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_P((863 - 0)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_P((863 - 0)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_P((863 - 0)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_P((863 - 0)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_P((863 - 0)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_P((863 - 0)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_P((863 - 0)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_P((863 - 0)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_P((863 - 0)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_P((2303 - 0)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_P((2303 - 0)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_P((2303 - 0)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_P((2303 - 0)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_P((2303 - 0)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_P((2303 - 0)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_P((2303 - 0)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_P((2303 - 0)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_P((2303 - 0)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_P((2303 - 0)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_P((2303 - 0)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_P((2303 - 0)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_P((2303 - 0)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_P((2303 - 0)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_P((2303 - 0)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_P((2303 - 0)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_P((2303 - 0)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_P((2303 - 0)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_P((2303 - 0)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_P((2303 - 0)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_P((2303 - 0)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_P((2303 - 0)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_P((2303 - 0)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_P((2303 - 0)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_P((2303 - 0)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_P((2303 - 0)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_P((2303 - 0)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_P((2303 - 0)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_P((2303 - 0)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_P((2303 - 0)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_P((2303 - 0)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_P((2303 - 0)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_P((2303 - 0)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_P((2303 - 0)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_P((2303 - 0)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_P((2303 - 0)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_P((2303 - 0)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_P((2303 - 0)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_P((2303 - 0)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_P((2303 - 0)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_P((2303 - 0)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_P((2303 - 0)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_P((2303 - 0)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_P((2303 - 0)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_P((2303 - 0)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_P((2303 - 0)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_P((2303 - 0)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_P((2303 - 0)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_P(0), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_P((335 - 0)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_P((335 - 0)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_P((335 - 0)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_P((335 - 0)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_P((335 - 0)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_P((335 - 0)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_P((335 - 0)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_P((2303 - 0)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_P((2303 - 0)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_P((2303 - 0)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_P((2303 - 0)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_P((2303 - 0)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_P((2303 - 0)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_P((2303 - 0)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_P((2303 - 0)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_P((2303 - 0)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_P((2303 - 0)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_P((2303 - 0)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_P((2303 - 0)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_P((2303 - 0)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_P((2303 - 0)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_P((2303 - 0)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_P((2303 - 0)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_P((2303 - 0)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_P((2303 - 0)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_P((2303 - 0)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_P((2303 - 0)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_P((2303 - 0)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_P((2303 - 0)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_P((2303 - 0)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_P((2303 - 0)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_P((2303 - 0)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_P((2303 - 0)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_P((2303 - 0)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_P((2303 - 0)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_P((2303 - 0)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_P((2303 - 0)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_P((2303 - 0)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_P((2303 - 0)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_P((2303 - 0)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_P((2303 - 0)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_P((2303 - 0)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_P((2303 - 0)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_P((2303 - 0)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_P((2303 - 0)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_P((2303 - 0)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_P((2303 - 0)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_P((2303 - 0)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_P((2303 - 0)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_P((2303 - 0)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_P((2303 - 0)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_P((2303 - 0)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_P((2303 - 0)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_P((2303 - 0)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_P((2303 - 0)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_P(0), true),
			159 => (CLK_dly'last_event, tpd_CLK_P(0), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(47),
         GlitchData	=> PCOUT_GlitchData(47),
         OutSignalName	=> "PCOUT(47)",
         OutTemp	=> PCOUT_zd(47),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 47)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 47)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 47)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 47)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 47)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 47)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 47)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 47)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 47)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 47)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 47)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 47)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 47)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 47)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 47)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 47)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 47)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 47)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 47)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 47)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 47)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 47)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 47)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 47)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 47)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 47)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 47)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 47)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 47)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 47)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 47)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 47)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 47)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 47)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 47)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 47)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 47)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 47)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 47)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 47)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 47)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 47)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 47)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 47)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 47)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 47)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 47)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 47)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 47)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 47)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 47)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 47)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 47)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 47)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 47)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 47)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 47)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 47)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 47)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 47)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 47)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 47)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 47)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 47)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 47)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 47)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 47)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 47)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 47)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 47)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 47)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 47)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 47)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 47)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 47)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 47)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 47)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 47)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 47)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 47)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 47)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 47)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 47)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 47)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 47)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(47), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 47)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 47)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(47), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(47), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(46),
         GlitchData	=> PCOUT_GlitchData(46),
         OutSignalName	=> "PCOUT(46)",
         OutTemp	=> PCOUT_zd(46),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 46)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 46)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 46)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 46)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 46)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 46)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 46)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 46)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 46)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 46)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 46)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 46)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 46)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 46)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 46)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 46)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 46)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 46)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 46)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 46)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 46)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 46)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 46)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 46)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 46)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 46)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 46)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 46)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 46)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 46)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 46)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 46)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 46)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 46)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 46)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 46)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 46)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 46)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 46)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 46)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 46)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 46)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 46)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 46)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 46)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 46)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 46)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 46)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 46)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 46)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 46)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 46)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 46)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 46)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 46)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 46)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 46)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 46)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 46)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 46)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 46)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 46)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 46)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 46)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 46)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 46)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 46)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 46)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 46)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 46)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 46)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 46)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 46)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 46)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 46)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 46)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 46)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 46)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 46)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 46)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 46)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 46)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 46)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 46)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 46)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(46), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 46)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 46)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(46), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(46), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(45),
         GlitchData	=> PCOUT_GlitchData(45),
         OutSignalName	=> "PCOUT(45)",
         OutTemp	=> PCOUT_zd(45),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 45)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 45)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 45)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 45)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 45)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 45)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 45)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 45)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 45)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 45)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 45)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 45)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 45)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 45)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 45)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 45)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 45)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 45)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 45)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 45)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 45)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 45)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 45)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 45)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 45)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 45)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 45)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 45)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 45)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 45)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 45)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 45)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 45)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 45)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 45)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 45)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 45)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 45)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 45)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 45)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 45)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 45)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 45)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 45)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 45)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 45)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 45)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 45)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 45)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 45)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 45)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 45)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 45)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 45)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 45)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 45)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 45)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 45)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 45)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 45)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 45)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 45)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 45)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 45)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 45)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 45)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 45)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 45)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 45)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 45)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 45)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 45)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 45)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 45)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 45)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 45)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 45)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 45)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 45)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 45)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 45)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 45)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 45)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 45)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 45)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(45), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 45)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 45)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(45), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(45), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(44),
         GlitchData	=> PCOUT_GlitchData(44),
         OutSignalName	=> "PCOUT(44)",
         OutTemp	=> PCOUT_zd(44),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 44)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 44)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 44)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 44)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 44)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 44)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 44)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 44)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 44)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 44)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 44)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 44)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 44)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 44)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 44)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 44)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 44)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 44)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 44)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 44)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 44)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 44)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 44)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 44)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 44)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 44)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 44)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 44)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 44)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 44)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 44)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 44)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 44)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 44)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 44)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 44)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 44)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 44)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 44)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 44)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 44)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 44)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 44)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 44)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 44)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 44)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 44)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 44)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 44)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 44)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 44)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 44)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 44)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 44)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 44)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 44)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 44)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 44)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 44)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 44)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 44)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 44)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 44)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 44)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 44)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 44)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 44)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 44)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 44)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 44)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 44)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 44)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 44)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 44)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 44)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 44)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 44)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 44)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 44)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 44)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 44)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 44)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 44)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 44)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 44)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(44), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 44)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 44)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(44), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(44), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(43),
         GlitchData	=> PCOUT_GlitchData(43),
         OutSignalName	=> "PCOUT(43)",
         OutTemp	=> PCOUT_zd(43),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 43)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 43)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 43)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 43)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 43)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 43)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 43)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 43)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 43)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 43)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 43)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 43)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 43)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 43)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 43)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 43)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 43)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 43)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 43)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 43)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 43)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 43)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 43)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 43)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 43)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 43)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 43)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 43)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 43)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 43)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 43)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 43)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 43)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 43)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 43)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 43)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 43)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 43)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 43)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 43)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 43)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 43)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 43)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 43)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 43)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 43)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 43)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 43)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 43)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 43)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 43)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 43)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 43)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 43)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 43)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 43)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 43)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 43)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 43)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 43)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 43)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 43)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 43)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 43)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 43)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 43)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 43)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 43)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 43)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 43)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 43)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 43)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 43)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 43)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 43)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 43)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 43)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 43)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 43)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 43)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 43)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 43)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 43)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 43)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 43)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(43), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 43)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 43)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(43), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(43), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(42),
         GlitchData	=> PCOUT_GlitchData(42),
         OutSignalName	=> "PCOUT(42)",
         OutTemp	=> PCOUT_zd(42),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 42)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 42)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 42)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 42)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 42)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 42)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 42)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 42)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 42)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 42)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 42)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 42)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 42)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 42)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 42)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 42)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 42)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 42)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 42)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 42)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 42)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 42)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 42)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 42)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 42)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 42)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 42)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 42)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 42)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 42)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 42)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 42)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 42)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 42)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 42)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 42)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 42)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 42)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 42)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 42)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 42)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 42)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 42)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 42)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 42)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 42)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 42)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 42)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 42)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 42)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 42)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 42)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 42)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 42)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 42)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 42)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 42)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 42)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 42)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 42)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 42)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 42)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 42)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 42)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 42)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 42)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 42)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 42)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 42)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 42)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 42)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 42)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 42)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 42)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 42)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 42)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 42)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 42)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 42)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 42)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 42)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 42)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 42)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 42)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 42)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(42), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 42)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 42)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(42), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(42), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(41),
         GlitchData	=> PCOUT_GlitchData(41),
         OutSignalName	=> "PCOUT(41)",
         OutTemp	=> PCOUT_zd(41),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 41)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 41)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 41)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 41)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 41)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 41)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 41)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 41)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 41)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 41)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 41)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 41)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 41)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 41)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 41)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 41)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 41)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 41)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 41)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 41)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 41)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 41)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 41)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 41)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 41)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 41)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 41)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 41)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 41)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 41)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 41)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 41)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 41)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 41)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 41)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 41)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 41)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 41)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 41)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 41)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 41)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 41)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 41)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 41)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 41)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 41)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 41)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 41)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 41)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 41)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 41)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 41)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 41)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 41)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 41)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 41)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 41)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 41)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 41)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 41)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 41)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 41)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 41)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 41)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 41)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 41)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 41)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 41)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 41)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 41)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 41)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 41)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 41)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 41)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 41)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 41)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 41)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 41)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 41)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 41)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 41)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 41)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 41)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 41)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 41)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(41), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 41)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 41)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(41), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(41), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(40),
         GlitchData	=> PCOUT_GlitchData(40),
         OutSignalName	=> "PCOUT(40)",
         OutTemp	=> PCOUT_zd(40),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 40)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 40)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 40)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 40)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 40)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 40)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 40)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 40)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 40)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 40)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 40)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 40)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 40)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 40)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 40)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 40)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 40)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 40)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 40)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 40)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 40)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 40)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 40)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 40)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 40)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 40)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 40)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 40)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 40)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 40)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 40)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 40)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 40)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 40)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 40)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 40)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 40)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 40)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 40)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 40)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 40)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 40)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 40)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 40)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 40)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 40)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 40)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 40)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 40)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 40)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 40)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 40)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 40)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 40)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 40)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 40)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 40)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 40)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 40)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 40)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 40)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 40)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 40)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 40)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 40)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 40)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 40)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 40)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 40)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 40)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 40)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 40)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 40)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 40)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 40)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 40)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 40)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 40)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 40)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 40)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 40)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 40)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 40)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 40)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 40)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(40), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 40)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 40)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(40), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(40), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(39),
         GlitchData	=> PCOUT_GlitchData(39),
         OutSignalName	=> "PCOUT(39)",
         OutTemp	=> PCOUT_zd(39),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 39)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 39)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 39)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 39)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 39)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 39)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 39)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 39)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 39)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 39)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 39)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 39)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 39)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 39)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 39)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 39)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 39)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 39)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 39)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 39)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 39)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 39)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 39)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 39)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 39)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 39)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 39)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 39)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 39)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 39)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 39)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 39)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 39)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 39)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 39)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 39)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 39)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 39)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 39)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 39)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 39)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 39)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 39)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 39)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 39)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 39)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 39)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 39)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 39)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 39)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 39)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 39)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 39)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 39)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 39)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 39)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 39)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 39)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 39)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 39)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 39)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 39)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 39)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 39)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 39)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 39)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 39)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 39)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 39)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 39)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 39)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 39)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 39)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 39)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 39)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 39)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 39)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 39)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 39)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 39)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 39)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 39)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 39)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 39)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 39)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(39), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 39)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 39)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(39), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(39), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(38),
         GlitchData	=> PCOUT_GlitchData(38),
         OutSignalName	=> "PCOUT(38)",
         OutTemp	=> PCOUT_zd(38),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 38)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 38)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 38)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 38)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 38)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 38)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 38)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 38)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 38)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 38)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 38)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 38)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 38)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 38)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 38)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 38)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 38)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 38)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 38)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 38)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 38)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 38)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 38)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 38)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 38)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 38)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 38)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 38)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 38)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 38)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 38)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 38)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 38)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 38)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 38)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 38)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 38)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 38)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 38)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 38)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 38)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 38)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 38)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 38)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 38)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 38)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 38)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 38)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 38)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 38)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 38)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 38)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 38)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 38)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 38)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 38)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 38)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 38)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 38)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 38)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 38)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 38)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 38)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 38)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 38)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 38)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 38)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 38)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 38)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 38)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 38)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 38)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 38)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 38)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 38)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 38)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 38)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 38)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 38)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 38)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 38)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 38)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 38)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 38)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 38)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(38), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 38)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 38)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(38), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(38), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(37),
         GlitchData	=> PCOUT_GlitchData(37),
         OutSignalName	=> "PCOUT(37)",
         OutTemp	=> PCOUT_zd(37),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 37)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 37)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 37)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 37)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 37)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 37)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 37)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 37)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 37)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 37)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 37)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 37)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 37)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 37)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 37)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 37)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 37)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 37)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 37)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 37)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 37)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 37)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 37)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 37)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 37)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 37)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 37)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 37)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 37)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 37)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 37)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 37)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 37)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 37)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 37)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 37)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 37)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 37)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 37)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 37)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 37)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 37)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 37)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 37)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 37)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 37)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 37)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 37)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 37)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 37)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 37)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 37)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 37)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 37)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 37)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 37)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 37)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 37)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 37)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 37)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 37)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 37)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 37)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 37)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 37)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 37)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 37)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 37)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 37)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 37)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 37)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 37)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 37)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 37)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 37)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 37)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 37)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 37)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 37)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 37)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 37)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 37)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 37)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 37)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 37)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(37), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 37)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 37)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(37), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(37), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(36),
         GlitchData	=> PCOUT_GlitchData(36),
         OutSignalName	=> "PCOUT(36)",
         OutTemp	=> PCOUT_zd(36),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 36)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 36)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 36)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 36)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 36)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 36)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 36)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 36)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 36)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 36)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 36)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 36)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 36)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 36)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 36)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 36)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 36)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 36)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 36)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 36)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 36)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 36)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 36)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 36)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 36)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 36)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 36)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 36)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 36)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 36)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 36)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 36)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 36)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 36)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 36)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 36)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 36)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 36)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 36)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 36)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 36)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 36)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 36)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 36)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 36)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 36)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 36)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 36)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 36)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 36)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 36)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 36)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 36)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 36)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 36)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 36)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 36)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 36)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 36)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 36)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 36)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 36)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 36)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 36)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 36)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 36)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 36)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 36)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 36)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 36)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 36)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 36)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 36)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 36)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 36)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 36)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 36)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 36)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 36)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 36)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 36)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 36)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 36)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 36)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 36)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(36), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 36)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 36)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(36), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(36), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(35),
         GlitchData	=> PCOUT_GlitchData(35),
         OutSignalName	=> "PCOUT(35)",
         OutTemp	=> PCOUT_zd(35),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 35)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 35)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 35)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 35)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 35)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 35)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 35)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 35)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 35)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 35)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 35)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 35)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 35)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 35)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 35)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 35)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 35)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 35)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 35)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 35)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 35)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 35)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 35)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 35)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 35)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 35)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 35)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 35)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 35)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 35)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 35)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 35)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 35)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 35)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 35)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 35)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 35)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 35)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 35)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 35)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 35)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 35)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 35)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 35)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 35)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 35)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 35)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 35)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 35)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 35)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 35)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 35)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 35)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 35)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 35)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 35)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 35)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 35)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 35)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 35)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 35)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 35)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 35)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 35)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 35)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 35)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 35)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 35)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 35)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 35)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 35)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 35)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 35)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 35)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 35)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 35)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 35)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 35)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 35)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 35)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 35)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 35)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 35)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 35)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 35)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(35), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 35)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 35)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(35), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(35), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(34),
         GlitchData	=> PCOUT_GlitchData(34),
         OutSignalName	=> "PCOUT(34)",
         OutTemp	=> PCOUT_zd(34),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 34)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 34)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 34)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 34)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 34)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 34)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 34)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 34)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 34)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 34)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 34)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 34)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 34)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 34)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 34)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 34)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 34)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 34)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 34)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 34)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 34)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 34)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 34)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 34)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 34)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 34)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 34)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 34)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 34)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 34)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 34)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 34)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 34)- 48*14), true),
			33 => (B_ipd(15)'last_event, tpd_B_PCOUT((863 - 34)- 48*15), true),
			34 => (B_ipd(16)'last_event, tpd_B_PCOUT((863 - 34)- 48*16), true),
			35 => (B_ipd(17)'last_event, tpd_B_PCOUT((863 - 34)- 48*17), true),
			36 => (BCIN_ipd(0)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*0), true),
			37 => (BCIN_ipd(1)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*1), true),
			38 => (BCIN_ipd(2)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*2), true),
			39 => (BCIN_ipd(3)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*3), true),
			40 => (BCIN_ipd(4)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*4), true),
			41 => (BCIN_ipd(5)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*5), true),
			42 => (BCIN_ipd(6)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*6), true),
			43 => (BCIN_ipd(7)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*7), true),
			44 => (BCIN_ipd(8)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*8), true),
			45 => (BCIN_ipd(9)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*9), true),
			46 => (BCIN_ipd(10)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*10), true),
			47 => (BCIN_ipd(11)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*11), true),
			48 => (BCIN_ipd(12)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*12), true),
			49 => (BCIN_ipd(13)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*13), true),
			50 => (BCIN_ipd(14)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*14), true),
			51 => (BCIN_ipd(15)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*15), true),
			52 => (BCIN_ipd(16)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*16), true),
			53 => (BCIN_ipd(17)'last_event, tpd_BCIN_PCOUT((863 - 34)- 48*17), true),
			54 => (C_ipd(0)'last_event, tpd_C_PCOUT((2303 - 34)- 48*0), true),
			55 => (C_ipd(1)'last_event, tpd_C_PCOUT((2303 - 34)- 48*1), true),
			56 => (C_ipd(2)'last_event, tpd_C_PCOUT((2303 - 34)- 48*2), true),
			57 => (C_ipd(3)'last_event, tpd_C_PCOUT((2303 - 34)- 48*3), true),
			58 => (C_ipd(4)'last_event, tpd_C_PCOUT((2303 - 34)- 48*4), true),
			59 => (C_ipd(5)'last_event, tpd_C_PCOUT((2303 - 34)- 48*5), true),
			60 => (C_ipd(6)'last_event, tpd_C_PCOUT((2303 - 34)- 48*6), true),
			61 => (C_ipd(7)'last_event, tpd_C_PCOUT((2303 - 34)- 48*7), true),
			62 => (C_ipd(8)'last_event, tpd_C_PCOUT((2303 - 34)- 48*8), true),
			63 => (C_ipd(9)'last_event, tpd_C_PCOUT((2303 - 34)- 48*9), true),
			64 => (C_ipd(10)'last_event, tpd_C_PCOUT((2303 - 34)- 48*10), true),
			65 => (C_ipd(11)'last_event, tpd_C_PCOUT((2303 - 34)- 48*11), true),
			66 => (C_ipd(12)'last_event, tpd_C_PCOUT((2303 - 34)- 48*12), true),
			67 => (C_ipd(13)'last_event, tpd_C_PCOUT((2303 - 34)- 48*13), true),
			68 => (C_ipd(14)'last_event, tpd_C_PCOUT((2303 - 34)- 48*14), true),
			69 => (C_ipd(15)'last_event, tpd_C_PCOUT((2303 - 34)- 48*15), true),
			70 => (C_ipd(16)'last_event, tpd_C_PCOUT((2303 - 34)- 48*16), true),
			71 => (C_ipd(17)'last_event, tpd_C_PCOUT((2303 - 34)- 48*17), true),
			72 => (C_ipd(18)'last_event, tpd_C_PCOUT((2303 - 34)- 48*18), true),
			73 => (C_ipd(19)'last_event, tpd_C_PCOUT((2303 - 34)- 48*19), true),
			74 => (C_ipd(20)'last_event, tpd_C_PCOUT((2303 - 34)- 48*20), true),
			75 => (C_ipd(21)'last_event, tpd_C_PCOUT((2303 - 34)- 48*21), true),
			76 => (C_ipd(22)'last_event, tpd_C_PCOUT((2303 - 34)- 48*22), true),
			77 => (C_ipd(23)'last_event, tpd_C_PCOUT((2303 - 34)- 48*23), true),
			78 => (C_ipd(24)'last_event, tpd_C_PCOUT((2303 - 34)- 48*24), true),
			79 => (C_ipd(25)'last_event, tpd_C_PCOUT((2303 - 34)- 48*25), true),
			80 => (C_ipd(26)'last_event, tpd_C_PCOUT((2303 - 34)- 48*26), true),
			81 => (C_ipd(27)'last_event, tpd_C_PCOUT((2303 - 34)- 48*27), true),
			82 => (C_ipd(28)'last_event, tpd_C_PCOUT((2303 - 34)- 48*28), true),
			83 => (C_ipd(29)'last_event, tpd_C_PCOUT((2303 - 34)- 48*29), true),
			84 => (C_ipd(30)'last_event, tpd_C_PCOUT((2303 - 34)- 48*30), true),
			85 => (C_ipd(31)'last_event, tpd_C_PCOUT((2303 - 34)- 48*31), true),
			86 => (C_ipd(32)'last_event, tpd_C_PCOUT((2303 - 34)- 48*32), true),
			87 => (C_ipd(33)'last_event, tpd_C_PCOUT((2303 - 34)- 48*33), true),
			88 => (C_ipd(34)'last_event, tpd_C_PCOUT((2303 - 34)- 48*34), true),
			89 => (C_ipd(35)'last_event, tpd_C_PCOUT((2303 - 34)- 48*35), true),
			90 => (C_ipd(36)'last_event, tpd_C_PCOUT((2303 - 34)- 48*36), true),
			91 => (C_ipd(37)'last_event, tpd_C_PCOUT((2303 - 34)- 48*37), true),
			92 => (C_ipd(38)'last_event, tpd_C_PCOUT((2303 - 34)- 48*38), true),
			93 => (C_ipd(39)'last_event, tpd_C_PCOUT((2303 - 34)- 48*39), true),
			94 => (C_ipd(40)'last_event, tpd_C_PCOUT((2303 - 34)- 48*40), true),
			95 => (C_ipd(41)'last_event, tpd_C_PCOUT((2303 - 34)- 48*41), true),
			96 => (C_ipd(42)'last_event, tpd_C_PCOUT((2303 - 34)- 48*42), true),
			97 => (C_ipd(43)'last_event, tpd_C_PCOUT((2303 - 34)- 48*43), true),
			98 => (C_ipd(44)'last_event, tpd_C_PCOUT((2303 - 34)- 48*44), true),
			99 => (C_ipd(45)'last_event, tpd_C_PCOUT((2303 - 34)- 48*45), true),
			100 => (C_ipd(46)'last_event, tpd_C_PCOUT((2303 - 34)- 48*46), true),
			101 => (C_ipd(47)'last_event, tpd_C_PCOUT((2303 - 34)- 48*47), true),
			102 => (CARRYIN_ipd'last_event, tpd_CARRYIN_PCOUT(34), true),
			103 => (OPMODE_ipd(0)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*0), true),
			104 => (OPMODE_ipd(1)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*1), true),
			105 => (OPMODE_ipd(2)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*2), true),
			106 => (OPMODE_ipd(3)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*3), true),
			107 => (OPMODE_ipd(4)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*4), true),
			108 => (OPMODE_ipd(5)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*5), true),
			109 => (OPMODE_ipd(6)'last_event, tpd_OPMODE_PCOUT((335 - 34)- 48*6), true),
			110 => (PCIN_ipd(0)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*0), true),
			111 => (PCIN_ipd(1)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*1), true),
			112 => (PCIN_ipd(2)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*2), true),
			113 => (PCIN_ipd(3)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*3), true),
			114 => (PCIN_ipd(4)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*4), true),
			115 => (PCIN_ipd(5)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*5), true),
			116 => (PCIN_ipd(6)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*6), true),
			117 => (PCIN_ipd(7)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*7), true),
			118 => (PCIN_ipd(8)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*8), true),
			119 => (PCIN_ipd(9)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*9), true),
			120 => (PCIN_ipd(10)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*10), true),
			121 => (PCIN_ipd(11)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*11), true),
			122 => (PCIN_ipd(12)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*12), true),
			123 => (PCIN_ipd(13)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*13), true),
			124 => (PCIN_ipd(14)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*14), true),
			125 => (PCIN_ipd(15)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*15), true),
			126 => (PCIN_ipd(16)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*16), true),
			127 => (PCIN_ipd(17)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*17), true),
			128 => (PCIN_ipd(18)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*18), true),
			129 => (PCIN_ipd(19)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*19), true),
			130 => (PCIN_ipd(20)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*20), true),
			131 => (PCIN_ipd(21)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*21), true),
			132 => (PCIN_ipd(22)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*22), true),
			133 => (PCIN_ipd(23)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*23), true),
			134 => (PCIN_ipd(24)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*24), true),
			135 => (PCIN_ipd(25)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*25), true),
			136 => (PCIN_ipd(26)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*26), true),
			137 => (PCIN_ipd(27)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*27), true),
			138 => (PCIN_ipd(28)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*28), true),
			139 => (PCIN_ipd(29)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*29), true),
			140 => (PCIN_ipd(30)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*30), true),
			141 => (PCIN_ipd(31)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*31), true),
			142 => (PCIN_ipd(32)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*32), true),
			143 => (PCIN_ipd(33)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*33), true),
			144 => (PCIN_ipd(34)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*34), true),
			145 => (PCIN_ipd(35)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*35), true),
			146 => (PCIN_ipd(36)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*36), true),
			147 => (PCIN_ipd(37)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*37), true),
			148 => (PCIN_ipd(38)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*38), true),
			149 => (PCIN_ipd(39)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*39), true),
			150 => (PCIN_ipd(40)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*40), true),
			151 => (PCIN_ipd(41)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*41), true),
			152 => (PCIN_ipd(42)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*42), true),
			153 => (PCIN_ipd(43)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*43), true),
			154 => (PCIN_ipd(44)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*44), true),
			155 => (PCIN_ipd(45)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*45), true),
			156 => (PCIN_ipd(46)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*46), true),
			157 => (PCIN_ipd(47)'last_event, tpd_PCIN_PCOUT((2303 - 34)- 48*47), true),
			158 => (SUBTRACT_ipd'last_event, tpd_SUBTRACT_PCOUT(34), true),
			159 => (CLK_dly'last_event, tpd_CLK_PCOUT(34), true)),
         Mode		=> VitalTransport,
         Xon		=> Xon,
         MsgOn		=> MsgOn,
         MsgSeverity	=> warning);

       VitalPathDelay01 (
         OutSignal	=> PCOUT(33),
         GlitchData	=> PCOUT_GlitchData(33),
         OutSignalName	=> "PCOUT(33)",
         OutTemp	=> PCOUT_zd(33),
         Paths		=> (
			0 => (A_ipd(0)'last_event, tpd_A_PCOUT((863 - 33)- 48*0), true),
			1 => (A_ipd(1)'last_event, tpd_A_PCOUT((863 - 33)- 48*1), true),
			2 => (A_ipd(2)'last_event, tpd_A_PCOUT((863 - 33)- 48*2), true),
			3 => (A_ipd(3)'last_event, tpd_A_PCOUT((863 - 33)- 48*3), true),
			4 => (A_ipd(4)'last_event, tpd_A_PCOUT((863 - 33)- 48*4), true),
			5 => (A_ipd(5)'last_event, tpd_A_PCOUT((863 - 33)- 48*5), true),
			6 => (A_ipd(6)'last_event, tpd_A_PCOUT((863 - 33)- 48*6), true),
			7 => (A_ipd(7)'last_event, tpd_A_PCOUT((863 - 33)- 48*7), true),
			8 => (A_ipd(8)'last_event, tpd_A_PCOUT((863 - 33)- 48*8), true),
			9 => (A_ipd(9)'last_event, tpd_A_PCOUT((863 - 33)- 48*9), true),
			10 => (A_ipd(10)'last_event, tpd_A_PCOUT((863 - 33)- 48*10), true),
			11 => (A_ipd(11)'last_event, tpd_A_PCOUT((863 - 33)- 48*11), true),
			12 => (A_ipd(12)'last_event, tpd_A_PCOUT((863 - 33)- 48*12), true),
			13 => (A_ipd(13)'last_event, tpd_A_PCOUT((863 - 33)- 48*13), true),
			14 => (A_ipd(14)'last_event, tpd_A_PCOUT((863 - 33)- 48*14), true),
			15 => (A_ipd(15)'last_event, tpd_A_PCOUT((863 - 33)- 48*15), true),
			16 => (A_ipd(16)'last_event, tpd_A_PCOUT((863 - 33)- 48*16), true),
			17 => (A_ipd(17)'last_event, tpd_A_PCOUT((863 - 33)- 48*17), true),
			18 => (B_ipd(0)'last_event, tpd_B_PCOUT((863 - 33)- 48*0), true),
			19 => (B_ipd(1)'last_event, tpd_B_PCOUT((863 - 33)- 48*1), true),
			20 => (B_ipd(2)'last_event, tpd_B_PCOUT((863 - 33)- 48*2), true),
			21 => (B_ipd(3)'last_event, tpd_B_PCOUT((863 - 33)- 48*3), true),
			22 => (B_ipd(4)'last_event, tpd_B_PCOUT((863 - 33)- 48*4), true),
			23 => (B_ipd(5)'last_event, tpd_B_PCOUT((863 - 33)- 48*5), true),
			24 => (B_ipd(6)'last_event, tpd_B_PCOUT((863 - 33)- 48*6), true),
			25 => (B_ipd(7)'last_event, tpd_B_PCOUT((863 - 33)- 48*7), true),
			26 => (B_ipd(8)'last_event, tpd_B_PCOUT((863 - 33)- 48*8), true),
			27 => (B_ipd(9)'last_event, tpd_B_PCOUT((863 - 33)- 48*9), true),
			28 => (B_ipd(10)'last_event, tpd_B_PCOUT((863 - 33)- 48*10), true),
			29 => (B_ipd(11)'last_event, tpd_B_PCOUT((863 - 33)- 48*11), true),
			30 => (B_ipd(12)'last_event, tpd_B_PCOUT((863 - 33)- 48*12), true),
			31 => (B_ipd(13)'last_event, tpd_B_PCOUT((863 - 33)- 48*13), true),
			32 => (B_ipd(14)'last_event, tpd_B_PCOUT((863 - 33)- 48*14), true),
			33 => (B_ipd(15)'last_event, tp